/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl.node;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.MutableTreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.SimpleContainerNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.ValueNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;

@NonNullByDefault
public abstract class TreeNode
implements Identifiable<YangInstanceIdentifier.PathArgument>,
StoreTreeNode<TreeNode> {
    private final NormalizedNode data;
    private final Version version;

    TreeNode(NormalizedNode data, Version version) {
        this.data = Objects.requireNonNull(data);
        this.version = Objects.requireNonNull(version);
    }

    public static final TreeNode of(NormalizedNode data, Version version) {
        if (data instanceof DistinctNodeContainer) {
            DistinctNodeContainer container = (DistinctNodeContainer)data;
            return new SimpleContainerNode((NormalizedNode)container, version);
        }
        if (data instanceof OrderedNodeContainer) {
            return new SimpleContainerNode(data, version);
        }
        return new ValueNode(data, version);
    }

    public final YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.data.name();
    }

    public final Version getVersion() {
        return this.version;
    }

    public abstract Version getSubtreeVersion();

    public final NormalizedNode getData() {
        return this.data;
    }

    public abstract MutableTreeNode mutable();

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).add("version", (Object)this.version)).toString();
    }

    abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);
}

