/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.leafref;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefContextBuilder;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefContextTreeBuilder;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefUtils;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

public final class LeafRefContext {
    private final @NonNull EffectiveModelContext modelContext;
    private final QName currentNodeQName;
    private final ImmutableList<QName> currentNodePath;
    private final Module module;
    private final LeafRefPath leafRefTargetPath;
    private final LeafRefPath absoluteLeafRefTargetPath;
    private final String leafRefTargetPathString;
    private final boolean isReferencedBy;
    private final boolean isReferencing;
    private final ImmutableMap<QName, LeafRefContext> referencingChilds;
    private final ImmutableMap<QName, LeafRefContext> referencedByChilds;
    private final ImmutableMap<QName, LeafRefContext> referencedByLeafRefCtx;
    private volatile LeafRefPath leafRefNodePath = null;

    LeafRefContext(LeafRefContextBuilder leafRefContextBuilder) {
        this.modelContext = Objects.requireNonNull(leafRefContextBuilder.modelContext());
        this.currentNodeQName = leafRefContextBuilder.getCurrentNodeQName();
        this.currentNodePath = leafRefContextBuilder.getCurrentNodePath();
        this.leafRefTargetPath = leafRefContextBuilder.getLeafRefTargetPath();
        this.absoluteLeafRefTargetPath = leafRefContextBuilder.getAbsoluteLeafRefTargetPath();
        this.leafRefTargetPathString = leafRefContextBuilder.getLeafRefTargetPathString();
        this.isReferencedBy = leafRefContextBuilder.isReferencedBy();
        this.isReferencing = leafRefContextBuilder.isReferencing();
        this.referencingChilds = ImmutableMap.copyOf(leafRefContextBuilder.getReferencingChilds());
        this.referencedByChilds = ImmutableMap.copyOf(leafRefContextBuilder.getReferencedByChilds());
        this.referencedByLeafRefCtx = ImmutableMap.copyOf(leafRefContextBuilder.getAllReferencedByLeafRefCtxs());
        this.module = leafRefContextBuilder.getLeafRefContextModule();
    }

    public @NonNull EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    public static LeafRefContext create(EffectiveModelContext ctx) {
        return new LeafRefContextTreeBuilder(ctx).buildLeafRefContextTree();
    }

    public boolean hasLeafRefContextChild() {
        return this.hasReferencedChild() || this.hasReferencingChild();
    }

    public boolean hasReferencedChild() {
        return !this.referencedByChilds.isEmpty();
    }

    public boolean hasReferencingChild() {
        return !this.referencingChilds.isEmpty();
    }

    public boolean isReferenced() {
        return this.isReferencedBy;
    }

    public boolean isReferencing() {
        return this.isReferencing;
    }

    public LeafRefContext getReferencingChildByName(QName name) {
        return (LeafRefContext)this.referencingChilds.get((Object)name);
    }

    public Map<QName, LeafRefContext> getReferencingChilds() {
        return this.referencingChilds;
    }

    public LeafRefContext getReferencedChildByName(QName name) {
        return (LeafRefContext)this.referencedByChilds.get((Object)name);
    }

    public Map<QName, LeafRefContext> getReferencedByChilds() {
        return this.referencedByChilds;
    }

    public ImmutableList<QName> getCurrentNodePath() {
        return this.currentNodePath;
    }

    public LeafRefPath getLeafRefTargetPath() {
        return this.leafRefTargetPath;
    }

    public String getLeafRefTargetPathString() {
        return this.leafRefTargetPathString;
    }

    public QName getNodeName() {
        return this.currentNodeQName;
    }

    public LeafRefPath getAbsoluteLeafRefTargetPath() {
        return this.absoluteLeafRefTargetPath;
    }

    public Module getLeafRefContextModule() {
        return this.module;
    }

    public LeafRefContext getReferencedByLeafRefCtxByName(QName qname) {
        return (LeafRefContext)this.referencedByLeafRefCtx.get((Object)qname);
    }

    public Map<QName, LeafRefContext> getAllReferencedByLeafRefCtxs() {
        return this.referencedByLeafRefCtx;
    }

    @Beta
    public LeafRefContext getLeafRefReferencingContext(SchemaNodeIdentifier node) {
        Iterator<QName> iterator = this.descendantIterator(node);
        LeafRefContext leafRefCtx = null;
        LeafRefContext current = this;
        while (iterator.hasNext() && current != null) {
            QName qname = iterator.next();
            leafRefCtx = current.getReferencingChildByName(qname);
            if (!iterator.hasNext()) continue;
            current = leafRefCtx;
        }
        return leafRefCtx;
    }

    @Beta
    public LeafRefContext getLeafRefReferencedByContext(SchemaNodeIdentifier node) {
        Iterator<QName> iterator = this.descendantIterator(node);
        LeafRefContext leafRefCtx = null;
        LeafRefContext current = this;
        while (iterator.hasNext() && current != null) {
            QName qname = iterator.next();
            leafRefCtx = current.getReferencedChildByName(qname);
            if (!iterator.hasNext()) continue;
            current = leafRefCtx;
        }
        return leafRefCtx;
    }

    private Iterator<QName> descendantIterator(SchemaNodeIdentifier node) {
        Iterator<QName> nodeSteps = node.getNodeIdentifiers().iterator();
        if (node instanceof SchemaNodeIdentifier.Absolute) {
            for (QName myNext : this.currentNodePath) {
                Preconditions.checkArgument((boolean)nodeSteps.hasNext(), (String)"Node %s is an ancestor of %s", (Object)node, this.currentNodePath);
                QName nodeNext = nodeSteps.next();
                Preconditions.checkArgument((boolean)myNext.equals((Object)nodeNext), (String)"Node %s is not a descendant of %s", (Object)node, this.currentNodePath);
            }
        }
        return nodeSteps;
    }

    @Beta
    public boolean isLeafRef(SchemaNodeIdentifier node) {
        LeafRefContext leafRefReferencingContext = this.getLeafRefReferencingContext(node);
        return leafRefReferencingContext != null && leafRefReferencingContext.isReferencing();
    }

    @Beta
    public boolean hasLeafRefChild(SchemaNodeIdentifier node) {
        LeafRefContext leafRefReferencingContext = this.getLeafRefReferencingContext(node);
        return leafRefReferencingContext != null && leafRefReferencingContext.hasReferencingChild();
    }

    @Beta
    public boolean isReferencedByLeafRef(SchemaNodeIdentifier node) {
        LeafRefContext leafRefReferencedByContext = this.getLeafRefReferencedByContext(node);
        return leafRefReferencedByContext != null && leafRefReferencedByContext.isReferenced();
    }

    @Beta
    public boolean hasChildReferencedByLeafRef(SchemaNodeIdentifier node) {
        LeafRefContext leafRefReferencedByContext = this.getLeafRefReferencedByContext(node);
        return leafRefReferencedByContext != null && leafRefReferencedByContext.hasReferencedChild();
    }

    @Beta
    public List<LeafRefContext> findAllLeafRefChilds(SchemaNodeIdentifier node) {
        LeafRefContext ctx = this.getLeafRefReferencingContext(node);
        return ctx == null ? List.of() : ctx.findAllLeafRefChilds();
    }

    private List<LeafRefContext> findAllLeafRefChilds() {
        if (this.isReferencing()) {
            return List.of(this);
        }
        ArrayList<LeafRefContext> leafRefChilds = new ArrayList<LeafRefContext>();
        for (Map.Entry<QName, LeafRefContext> child : this.getReferencingChilds().entrySet()) {
            leafRefChilds.addAll(child.getValue().findAllLeafRefChilds());
        }
        return leafRefChilds;
    }

    @Beta
    public List<LeafRefContext> findAllChildsReferencedByLeafRef(SchemaNodeIdentifier node) {
        LeafRefContext ctx = this.getLeafRefReferencedByContext(node);
        return ctx == null ? List.of() : ctx.findAllChildsReferencedByLeafRef();
    }

    private List<LeafRefContext> findAllChildsReferencedByLeafRef() {
        if (this.isReferenced()) {
            return List.of(this);
        }
        ArrayList<LeafRefContext> childsReferencedByLeafRef = new ArrayList<LeafRefContext>();
        for (Map.Entry<QName, LeafRefContext> child : this.getReferencedByChilds().entrySet()) {
            childsReferencedByLeafRef.addAll(child.getValue().findAllChildsReferencedByLeafRef());
        }
        return childsReferencedByLeafRef;
    }

    @Beta
    public Map<QName, LeafRefContext> getAllLeafRefsReferencingThisNode(SchemaNodeIdentifier node) {
        LeafRefContext referencedByContext = this.getLeafRefReferencedByContext(node);
        return referencedByContext == null ? Map.of() : referencedByContext.getAllReferencedByLeafRefCtxs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LeafRefPath getLeafRefNodePath() {
        LeafRefPath ret = this.leafRefNodePath;
        if (ret == null) {
            LeafRefContext leafRefContext = this;
            synchronized (leafRefContext) {
                ret = this.leafRefNodePath;
                if (ret == null) {
                    ret = this.leafRefNodePath = LeafRefUtils.schemaPathToLeafRefPath(this.currentNodePath, this.module);
                }
            }
        }
        return ret;
    }
}

