/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.leafref;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Deque;
import java.util.LinkedList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNameWithPredicate;
import org.opendaylight.yangtools.yang.data.tree.leafref.SimpleQNameWithPredicate;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;

public final class LeafRefUtils {
    private LeafRefUtils() {
    }

    public static LeafRefPath createAbsoluteLeafRefPath(LeafRefPath leafRefPath, ImmutableList<QName> contextNodeSchemaPath, Module module) {
        if (leafRefPath.isAbsolute()) {
            return leafRefPath;
        }
        Deque<QNameWithPredicate> absoluteLeafRefTargetPathList = LeafRefUtils.schemaPathToXPathQNames(contextNodeSchemaPath, module);
        for (QNameWithPredicate qname : leafRefPath.getPathFromRoot()) {
            if (qname.equals(QNameWithPredicate.UP_PARENT)) {
                absoluteLeafRefTargetPathList.removeLast();
                continue;
            }
            absoluteLeafRefTargetPathList.add(qname);
        }
        return LeafRefPath.create(absoluteLeafRefTargetPathList, true);
    }

    private static Deque<QNameWithPredicate> schemaPathToXPathQNames(ImmutableList<QName> nodePath, Module module) {
        LinkedList<QNameWithPredicate> xpath = new LinkedList<QNameWithPredicate>();
        UnmodifiableIterator nodePathIterator = nodePath.iterator();
        Module currenDataNodeContainer = module;
        while (nodePathIterator.hasNext()) {
            QName qname = (QName)nodePathIterator.next();
            DataSchemaNode child = currenDataNodeContainer.dataChildByName(qname);
            if (child instanceof DataNodeContainer) {
                DataNodeContainer container = (DataNodeContainer)child;
                if (!(child instanceof CaseSchemaNode)) {
                    xpath.add(new SimpleQNameWithPredicate(qname));
                }
                currenDataNodeContainer = container;
                continue;
            }
            if (child instanceof ChoiceSchemaNode) {
                ChoiceSchemaNode choice = (ChoiceSchemaNode)child;
                if (!nodePathIterator.hasNext()) break;
                currenDataNodeContainer = choice.findCaseNode((QName)nodePathIterator.next()).orElse(null);
                continue;
            }
            if (child instanceof LeafSchemaNode || child instanceof LeafListSchemaNode) {
                xpath.add(new SimpleQNameWithPredicate(qname));
                break;
            }
            if (child == null) {
                throw new IllegalArgumentException("No child " + qname + " found in node container " + (DataNodeContainer)currenDataNodeContainer + " in module " + module.getName());
            }
            throw new IllegalStateException("Illegal schema node type in the path: " + child.getClass());
        }
        return xpath;
    }

    public static LeafRefPath schemaPathToLeafRefPath(ImmutableList<QName> nodePath, Module module) {
        return LeafRefPath.create(LeafRefUtils.schemaPathToXPathQNames(nodePath, module), true);
    }
}

