/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Objects;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;

abstract class AbstractReadyIterator {
    final Iterator<ModifiedNode> children;
    final ModifiedNode node;
    final ModificationApplyOperation op;

    private AbstractReadyIterator(ModifiedNode node, Iterator<ModifiedNode> children, ModificationApplyOperation operation) {
        this.children = Objects.requireNonNull(children);
        this.node = Objects.requireNonNull(node);
        this.op = Objects.requireNonNull(operation);
    }

    static AbstractReadyIterator create(ModifiedNode root, ModificationApplyOperation operation) {
        return new RootReadyIterator(root, root.getChildren().iterator(), operation);
    }

    final AbstractReadyIterator process(Version version) {
        while (this.children.hasNext()) {
            ModifiedNode child = this.children.next();
            YangInstanceIdentifier.PathArgument childId = child.getIdentifier();
            ModificationApplyOperation childOp = this.op.childByArg(childId);
            Preconditions.checkState((childOp != null ? 1 : 0) != 0, (String)"Schema for child %s is not present.", (Object)childId);
            if (child.isEmpty()) {
                child.seal(childOp, version);
                if (child.getOperation() != LogicalOperation.NONE) continue;
                this.children.remove();
                continue;
            }
            return new NestedReadyIterator(this, child, child.getChildren().iterator(), childOp);
        }
        this.node.seal(this.op, version);
        if (this.node.getOperation() == LogicalOperation.NONE) {
            this.removeFromParent();
        }
        return this.getParent();
    }

    abstract AbstractReadyIterator getParent();

    abstract void removeFromParent();

    private static final class RootReadyIterator
    extends AbstractReadyIterator {
        private RootReadyIterator(ModifiedNode node, Iterator<ModifiedNode> children, ModificationApplyOperation operation) {
            super(node, children, operation);
        }

        @Override
        AbstractReadyIterator getParent() {
            return null;
        }

        @Override
        void removeFromParent() {
        }
    }

    private static final class NestedReadyIterator
    extends AbstractReadyIterator {
        private final AbstractReadyIterator parent;

        private NestedReadyIterator(AbstractReadyIterator parent, ModifiedNode node, Iterator<ModifiedNode> children, ModificationApplyOperation operation) {
            super(node, children, operation);
            this.parent = Objects.requireNonNull(parent);
        }

        @Override
        AbstractReadyIterator getParent() {
            return this.parent;
        }

        @Override
        void removeFromParent() {
            this.parent.children.remove();
        }
    }
}

