/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.tree.impl.ChildTrackingPolicy;

final class NormalizedNodeContainerSupport<K extends YangInstanceIdentifier.PathArgument, T extends NormalizedNode> {
    final Function<T, NormalizedNodeContainerBuilder<K, ?, ?, T>> copyBuilder;
    final Supplier<NormalizedNodeContainerBuilder<K, ?, ?, T>> emptyBuilder;
    final ChildTrackingPolicy childPolicy;
    final Class<T> requiredClass;

    NormalizedNodeContainerSupport(Class<T> requiredClass, ChildTrackingPolicy childPolicy, Function<T, NormalizedNodeContainerBuilder<K, ?, ?, T>> copyBuilder, Supplier<NormalizedNodeContainerBuilder<K, ?, ?, T>> emptyBuilder) {
        this.requiredClass = Objects.requireNonNull(requiredClass);
        this.childPolicy = Objects.requireNonNull(childPolicy);
        this.copyBuilder = Objects.requireNonNull(copyBuilder);
        this.emptyBuilder = Objects.requireNonNull(emptyBuilder);
    }

    NormalizedNodeContainerSupport(Class<T> requiredClass, Function<T, NormalizedNodeContainerBuilder<K, ?, ?, T>> copyBuilder, Supplier<NormalizedNodeContainerBuilder<K, ?, ?, T>> emptyBuilder) {
        this(requiredClass, ChildTrackingPolicy.UNORDERED, copyBuilder, emptyBuilder);
    }

    NormalizedNodeContainerBuilder<?, ?, ?, T> createBuilder(NormalizedNode original) {
        return this.copyBuilder.apply(this.cast(original));
    }

    NormalizedNode createEmptyValue(NormalizedNode original) {
        return this.emptyBuilder.get().withNodeIdentifier(this.cast(original).name()).build();
    }

    private T cast(NormalizedNode original) {
        Preconditions.checkArgument((boolean)this.requiredClass.isInstance(original), (String)"Require %s, got %s", this.requiredClass, (Object)original);
        return (T)((NormalizedNode)this.requiredClass.cast(original));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("requiredClass", this.requiredClass).toString();
    }
}

