/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;

final class OperationWithModification {
    private final ModificationApplyOperation applyOperation;
    private final ModifiedNode modification;

    private OperationWithModification(ModificationApplyOperation op, ModifiedNode mod) {
        this.applyOperation = Objects.requireNonNull(op);
        this.modification = Objects.requireNonNull(mod);
    }

    void write(NormalizedNode value) {
        this.modification.write(value);
        this.applyOperation.quickVerifyStructure(value);
    }

    void merge(NormalizedNode data, Version version) {
        this.applyOperation.quickVerifyStructure(data);
        this.applyOperation.mergeIntoModifiedNode(this.modification, data, version);
    }

    void delete() {
        this.modification.delete();
    }

    Optional<NormalizedNode> read(YangInstanceIdentifier.PathArgument child, Version version) {
        ModifiedNode childNode = this.modification.childByArg(child);
        if (childNode != null) {
            Optional<TreeNode> snapshot = childNode.getSnapshot();
            if (snapshot == null) {
                snapshot = Optional.ofNullable(((ModificationApplyOperation)this.applyOperation.getChildByArg(child)).apply(childNode, childNode.original(), version));
            }
            return snapshot.map(TreeNode::data);
        }
        Optional<TreeNode> snapshot = this.modification.getSnapshot();
        if (snapshot == null) {
            snapshot = Optional.ofNullable(this.apply(this.modification.original(), version));
        }
        if (snapshot.isPresent()) {
            return snapshot.orElseThrow().findChildByArg(child).map(TreeNode::data);
        }
        return Optional.empty();
    }

    public ModifiedNode getModification() {
        return this.modification;
    }

    public ModificationApplyOperation getApplyOperation() {
        return this.applyOperation;
    }

    public @Nullable TreeNode apply(@Nullable TreeNode data, Version version) {
        return this.applyOperation.apply(this.modification, data, version);
    }

    public static OperationWithModification from(ModificationApplyOperation operation, ModifiedNode modification) {
        return new OperationWithModification(operation, modification);
    }
}

