/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl.di;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserMapNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeFactory;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTree;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContext;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.RequireServiceComponentRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component
@RequireServiceComponentRuntime
public final class InMemoryDataTreeFactory
implements DataTreeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDataTreeFactory.class);
    private static final NormalizedNode.BuilderFactory BUILDERS = ImmutableNodes.builderFactory();
    private static final @NonNull ContainerNode ROOT_CONTAINER = (ContainerNode)BUILDERS.newContainerBuilder(0).withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)SchemaContext.NAME)).build();

    @Inject
    public InMemoryDataTreeFactory() {
    }

    @Deprecated
    public DataTree create(DataTreeConfiguration treeConfig) {
        return new InMemoryDataTree(TreeNode.of(InMemoryDataTreeFactory.createRoot(treeConfig.getRootPath()), Version.initial(treeConfig.isVersionInfoTrackingEnabled())), treeConfig, null);
    }

    public DataTree create(DataTreeConfiguration treeConfig, EffectiveModelContext initialSchemaContext) {
        return InMemoryDataTreeFactory.createDataTree(treeConfig, initialSchemaContext, true);
    }

    public DataTree create(DataTreeConfiguration treeConfig, EffectiveModelContext initialSchemaContext, DistinctNodeContainer<?, ?> initialRoot) throws DataValidationFailedException {
        DataTree ret = InMemoryDataTreeFactory.createDataTree(treeConfig, initialSchemaContext, false);
        DataTreeModification mod = ret.takeSnapshot().newModification();
        mod.write(YangInstanceIdentifier.of(), initialRoot);
        mod.ready();
        ret.validate(mod);
        DataTreeCandidateTip candidate = ret.prepare(mod);
        ret.commit((DataTreeCandidate)candidate);
        return ret;
    }

    @Activate
    void activate() {
        LOG.debug("In-memory Data Tree activated");
    }

    @Deactivate
    void deactivate() {
        LOG.debug("In-memory Data Tree deactivated");
    }

    private static @NonNull DataTree createDataTree(DataTreeConfiguration treeConfig, EffectiveModelContext initialSchemaContext, boolean maskMandatory) {
        YangInstanceIdentifier rootPath = treeConfig.getRootPath();
        DataSchemaNode rootSchemaNode = InMemoryDataTreeFactory.getRootSchemaNode(initialSchemaContext, rootPath);
        NormalizedNode rootDataNode = InMemoryDataTreeFactory.createRoot((DataNodeContainer)rootSchemaNode, rootPath);
        return new InMemoryDataTree(TreeNode.of(rootDataNode, Version.initial(treeConfig.isVersionInfoTrackingEnabled())), treeConfig, initialSchemaContext, rootSchemaNode, maskMandatory);
    }

    private static @NonNull NormalizedNode createRoot(DataNodeContainer schemaNode, YangInstanceIdentifier path) {
        YangInstanceIdentifier.PathArgument arg = path.getLastPathArgument();
        if (arg == null) {
            if (schemaNode instanceof ContainerLike) {
                return ROOT_CONTAINER;
            }
            throw new IllegalArgumentException("Conceptual tree root has to be a container, not " + String.valueOf(schemaNode));
        }
        DataNodeContainer dataNodeContainer = schemaNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContainerSchemaNode.class, ListSchemaNode.class}, (Object)dataNodeContainer, n)) {
            case 0 -> {
                ContainerSchemaNode containerSchema = (ContainerSchemaNode)dataNodeContainer;
                YangInstanceIdentifier.PathArgument v0 = arg;
                Objects.requireNonNull(v0);
                YangInstanceIdentifier.PathArgument var7_6 = v0;
                int var8_8 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{YangInstanceIdentifier.NodeIdentifier.class}, (Object)var7_6, var8_8)) {
                    case 0: {
                        YangInstanceIdentifier.NodeIdentifier nid = (YangInstanceIdentifier.NodeIdentifier)var7_6;
                        yield (ContainerNode)BUILDERS.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)nid).build();
                    }
                }
                throw new IllegalArgumentException("Mismatched container " + String.valueOf(schemaNode) + " path " + String.valueOf(path));
            }
            case 1 -> {
                ListSchemaNode listSchema = (ListSchemaNode)dataNodeContainer;
                YangInstanceIdentifier.PathArgument v2 = arg;
                Objects.requireNonNull(v2);
                YangInstanceIdentifier.PathArgument var11_11 = v2;
                int var12_12 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{YangInstanceIdentifier.NodeIdentifierWithPredicates.class, YangInstanceIdentifier.NodeIdentifier.class, YangInstanceIdentifier.NodeWithValue.class}, (Object)var11_11, var12_12)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)var11_11;
                        yield (MapEntryNode)BUILDERS.newMapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)nip).build();
                    }
                    case 1: {
                        YangInstanceIdentifier.NodeIdentifier nid = (YangInstanceIdentifier.NodeIdentifier)var11_11;
                        UserMapNode.Builder builder = listSchema.isUserOrdered() ? BUILDERS.newUserMapBuilder() : BUILDERS.newSystemMapBuilder();
                        yield (MapNode)builder.withNodeIdentifier(nid).build();
                    }
                    case 2: 
                }
                YangInstanceIdentifier.NodeWithValue var = (YangInstanceIdentifier.NodeWithValue)var11_11;
                throw new IllegalArgumentException("Mismatched list " + String.valueOf(listSchema) + " path " + String.valueOf(path));
            }
            default -> throw new IllegalArgumentException("Unsupported root schema " + String.valueOf(schemaNode));
        };
    }

    private static @NonNull NormalizedNode createRoot(YangInstanceIdentifier path) {
        YangInstanceIdentifier.PathArgument pathArgument = path.getLastPathArgument();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{YangInstanceIdentifier.NodeIdentifier.class, YangInstanceIdentifier.NodeIdentifierWithPredicates.class, YangInstanceIdentifier.NodeWithValue.class}, (Object)pathArgument, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> ROOT_CONTAINER;
            case 0 -> {
                YangInstanceIdentifier.NodeIdentifier nid = (YangInstanceIdentifier.NodeIdentifier)pathArgument;
                yield (ContainerNode)BUILDERS.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)nid).build();
            }
            case 1 -> {
                YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArgument;
                yield (MapEntryNode)BUILDERS.newMapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)nip).build();
            }
            case 2 -> {
                YangInstanceIdentifier.NodeWithValue val = (YangInstanceIdentifier.NodeWithValue)pathArgument;
                throw new IllegalArgumentException("Unsupported root node " + String.valueOf(val));
            }
        };
    }

    private static DataSchemaNode getRootSchemaNode(EffectiveModelContext schemaContext, YangInstanceIdentifier rootPath) {
        DataSchemaContextTree contextTree = DataSchemaContextTree.from((EffectiveModelContext)schemaContext);
        DataSchemaContext rootContextNode = contextTree.childByPath(rootPath);
        if (rootContextNode == null) {
            throw new IllegalArgumentException("Failed to find root " + String.valueOf(rootPath) + " in schema context");
        }
        DataSchemaNode rootSchemaNode = rootContextNode.dataSchemaNode();
        if (rootSchemaNode instanceof DataNodeContainer) {
            return rootSchemaNode;
        }
        throw new IllegalArgumentException("Root " + String.valueOf(rootPath) + " resolves to non-container type " + String.valueOf(rootSchemaNode));
    }
}

