/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl.node;

import com.google.common.base.Verify;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.util.MapAdaptor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.AbstractContainerNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.LazyContainerNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.MaterializedContainerNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.MutableTreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.SimpleContainerNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;

abstract class AbstractMutableContainerNode
extends MutableTreeNode {
    private final @NonNull Version incarnation;
    private final @NonNull Version subtreeVersion;
    private Map<YangInstanceIdentifier.PathArgument, TreeNode> children;
    private @NonNull NormalizedNode data;

    AbstractMutableContainerNode(AbstractContainerNode parent, Version subtreeVersion, Map<YangInstanceIdentifier.PathArgument, TreeNode> children) {
        this.data = parent.data();
        this.incarnation = parent.incarnation();
        this.subtreeVersion = Objects.requireNonNull(subtreeVersion);
        this.children = Objects.requireNonNull(children);
    }

    final @NonNull Version incarnation() {
        return this.incarnation;
    }

    final TreeNode getModifiedChild(YangInstanceIdentifier.PathArgument child) {
        return this.children.get(child);
    }

    final DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode> getData() {
        return (DistinctNodeContainer)this.data;
    }

    @Override
    public final TreeNode putChild(TreeNode child) {
        return this.children.put(child.data().name(), child);
    }

    @Override
    public final TreeNode removeChild(YangInstanceIdentifier.PathArgument id) {
        return this.children.remove(Objects.requireNonNull(id));
    }

    @Override
    public final void setData(NormalizedNode data) {
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public final AbstractContainerNode seal() {
        AbstractContainerNode result = this.sealImpl();
        this.children = null;
        return result;
    }

    @NonNullByDefault
    private AbstractContainerNode sealImpl() {
        return this.incarnation.equals(this.subtreeVersion) ? new SimpleContainerNode(this.data, this.incarnation) : this.sealSubtree();
    }

    @NonNullByDefault
    private AbstractContainerNode sealSubtree() {
        int childrenSize;
        Map newChildren = MapAdaptor.getDefaultInstance().optimize(this.children);
        int dataSize = this.getData().size();
        if (dataSize == (childrenSize = newChildren.size())) {
            return new MaterializedContainerNode(this.data, this.incarnation, newChildren, this.subtreeVersion);
        }
        Verify.verify((dataSize > childrenSize ? 1 : 0) != 0, (String)"Detected %s modified children, data has only %s", (int)childrenSize, (int)dataSize);
        return new LazyContainerNode(this.data, this.incarnation, newChildren, this.subtreeVersion);
    }
}

