/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl.node;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Map;
import org.opendaylight.yangtools.util.MapAdaptor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.AbstractModifiedContainerNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.LazyMutableContainerNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.MaterializedMutableContainerNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.MutableTreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;

final class LazyContainerNode
extends AbstractModifiedContainerNode {
    LazyContainerNode(NormalizedNode data, Version version, Version subtreeVersion) {
        this(data, version, MapAdaptor.getDefaultInstance().initialSnapshot(1), subtreeVersion);
    }

    LazyContainerNode(NormalizedNode data, Version version, Map<YangInstanceIdentifier.PathArgument, TreeNode> children, Version subtreeVersion) {
        super(data, version, children, subtreeVersion);
    }

    @Override
    public MutableTreeNode toMutable(Version nextSubtreeVersion) {
        Map<YangInstanceIdentifier.PathArgument, TreeNode> snapshot = this.snapshotChildren();
        return snapshot.size() == this.castData().size() ? new MaterializedMutableContainerNode(this, nextSubtreeVersion, snapshot) : new LazyMutableContainerNode(this, nextSubtreeVersion, snapshot);
    }

    public TreeNode childByArg(YangInstanceIdentifier.PathArgument arg) {
        TreeNode modified = this.getModifiedChild(arg);
        return modified == null ? this.childFromData(arg) : modified;
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper).add("untouched", (Object)Collections2.filter((Collection)this.castData().body(), input -> this.getModifiedChild(input.name()) == null));
    }
}

