/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl.node;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.tree.api.VersionInfo;

public sealed class Version {
    private Version() {
    }

    public static final @NonNull Version initial(boolean trackInfo) {
        return trackInfo ? new WithInfo() : new Version();
    }

    public @NonNull Version next() {
        return new Version();
    }

    public @Nullable VersionInfo readInfo() {
        return null;
    }

    public @Nullable VersionInfo writeInfo(@Nullable VersionInfo newInfo) {
        return null;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("Version[").append(Integer.toHexString(this.hashCode()));
        VersionInfo info = this.readInfo();
        if (info != null) {
            sb.append(", ").append(info);
        }
        return sb.append(']').toString();
    }

    private static final class WithInfo
    extends Version {
        private static final @NonNull VersionInfo NULL = new VersionInfo(){};
        private static final VarHandle VH;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
        private volatile VersionInfo info;

        private WithInfo() {
        }

        @Override
        public WithInfo next() {
            return new WithInfo();
        }

        @Override
        public VersionInfo readInfo() {
            return WithInfo.unmaskNull(VH.getAcquire(this));
        }

        @Override
        public VersionInfo writeInfo(VersionInfo newInfo) {
            VersionInfo witness = VH.compareAndExchangeRelease(this, null, WithInfo.maskNull(newInfo));
            return witness == null ? newInfo : WithInfo.unmaskNull(witness);
        }

        private static @NonNull VersionInfo maskNull(@Nullable VersionInfo info) {
            return info != null ? info : NULL;
        }

        private static @Nullable VersionInfo unmaskNull(@Nullable VersionInfo info) {
            return info != NULL ? info : null;
        }

        static {
            try {
                VH = MethodHandles.lookup().findVarHandle(WithInfo.class, "info", VersionInfo.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

