/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.leafref;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.ValueNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefContext;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefDataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNamePredicate;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNameWithPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LeafRefValidation {
    private static final Logger LOG = LoggerFactory.getLogger(LeafRefValidation.class);
    private static final String FAILED = " -> FAILED";
    private static final String SUCCESS = " -> OK";
    private final Set<LeafRefContext> validatedLeafRefCtx = new HashSet<LeafRefContext>();
    private final List<String> errorsMessages = new ArrayList<String>();
    private final NormalizedNode root;

    private LeafRefValidation(NormalizedNode root) {
        this.root = root;
    }

    public static void validate(DataTreeCandidate tree, LeafRefContext rootLeafRefCtx) throws LeafRefDataValidationFailedException {
        NormalizedNode root = tree.getRootNode().dataAfter();
        if (root != null) {
            new LeafRefValidation(root).validateChildren(rootLeafRefCtx, tree.getRootNode().childNodes());
        }
    }

    private void validateChildren(LeafRefContext rootLeafRefCtx, Collection<DataTreeCandidateNode> children) throws LeafRefDataValidationFailedException {
        for (DataTreeCandidateNode dataTreeCandidateNode : children) {
            if (dataTreeCandidateNode.modificationType() == ModificationType.UNMODIFIED) continue;
            YangInstanceIdentifier.PathArgument identifier = dataTreeCandidateNode.name();
            QName childQName = identifier.getNodeType();
            LeafRefContext referencedByCtx = rootLeafRefCtx.getReferencedChildByName(childQName);
            LeafRefContext referencingCtx = rootLeafRefCtx.getReferencingChildByName(childQName);
            if (referencedByCtx == null && referencingCtx == null) continue;
            this.validateNode(dataTreeCandidateNode, referencedByCtx, referencingCtx, YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument)identifier));
        }
        if (!this.errorsMessages.isEmpty()) {
            StringBuilder message = new StringBuilder();
            int errCount = 0;
            for (String errorMessage : this.errorsMessages) {
                message.append(errorMessage);
                ++errCount;
            }
            throw new LeafRefDataValidationFailedException(message.toString(), errCount);
        }
    }

    private void validateNode(DataTreeCandidateNode node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, YangInstanceIdentifier current) {
        ModificationType modType = node.modificationType();
        if (modType == ModificationType.WRITE) {
            NormalizedNode dataAfter = node.dataAfter();
            if (dataAfter != null) {
                this.validateNodeData(dataAfter, referencedByCtx, referencingCtx, ModificationType.WRITE, current);
            }
            return;
        }
        if (modType == ModificationType.DELETE && referencedByCtx != null) {
            this.validateNodeData((NormalizedNode)Verify.verifyNotNull((Object)node.dataBefore()), referencedByCtx, null, node.modificationType(), current);
            return;
        }
        for (DataTreeCandidateNode childNode : node.childNodes()) {
            if (childNode.modificationType() == ModificationType.UNMODIFIED) continue;
            LeafRefContext childReferencedByCtx = LeafRefValidation.getReferencedByCtxChild(referencedByCtx, childNode);
            LeafRefContext childReferencingCtx = LeafRefValidation.getReferencingCtxChild(referencingCtx, childNode);
            if (childReferencedByCtx == null && childReferencingCtx == null) continue;
            this.validateNode(childNode, childReferencedByCtx, childReferencingCtx, current.node(childNode.name()));
        }
    }

    private static LeafRefContext getReferencingCtxChild(LeafRefContext referencingCtx, DataTreeCandidateNode childNode) {
        NormalizedNode data;
        if (referencingCtx == null) {
            return null;
        }
        QName childQName = childNode.name().getNodeType();
        LeafRefContext childReferencingCtx = referencingCtx.getReferencingChildByName(childQName);
        if (childReferencingCtx == null && ((data = (NormalizedNode)Verify.verifyNotNull((Object)childNode.dataAfter())) instanceof MapEntryNode || data instanceof UnkeyedListEntryNode)) {
            childReferencingCtx = referencingCtx;
        }
        return childReferencingCtx;
    }

    private static LeafRefContext getReferencedByCtxChild(LeafRefContext referencedByCtx, DataTreeCandidateNode childNode) {
        NormalizedNode data;
        if (referencedByCtx == null) {
            return null;
        }
        QName childQName = childNode.name().getNodeType();
        LeafRefContext childReferencedByCtx = referencedByCtx.getReferencedChildByName(childQName);
        if (childReferencedByCtx == null && ((data = (NormalizedNode)Verify.verifyNotNull((Object)childNode.dataAfter())) instanceof MapEntryNode || data instanceof UnkeyedListEntryNode)) {
            childReferencedByCtx = referencedByCtx;
        }
        return childReferencedByCtx;
    }

    private void validateNodeData(NormalizedNode node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        NormalizedNode normalizedNode = node;
        Objects.requireNonNull(normalizedNode);
        NormalizedNode normalizedNode2 = normalizedNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LeafNode.class, LeafSetNode.class, ChoiceNode.class, DataContainerNode.class, MapNode.class}, (Object)normalizedNode2, n)) {
            case 0: {
                LeafNode leaf = (LeafNode)normalizedNode2;
                this.validateLeafNodeData(leaf, referencedByCtx, referencingCtx, modificationType, current);
                break;
            }
            case 1: {
                LeafSetNode leafSet = (LeafSetNode)normalizedNode2;
                this.validateLeafSetNodeData(leafSet, referencedByCtx, referencingCtx, modificationType, current);
                break;
            }
            case 2: {
                ChoiceNode choice = (ChoiceNode)normalizedNode2;
                this.validateChoiceNodeData(choice, referencedByCtx, referencingCtx, modificationType, current);
                break;
            }
            case 3: {
                DataContainerNode container = (DataContainerNode)normalizedNode2;
                this.validateDataContainerNodeData(container, referencedByCtx, referencingCtx, modificationType, current);
                break;
            }
            case 4: {
                MapNode map = (MapNode)normalizedNode2;
                this.validateMapNodeData(map, referencedByCtx, referencingCtx, modificationType, current);
                break;
            }
        }
    }

    private void validateLeafNodeData(LeafNode<?> node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        if (referencedByCtx != null && referencedByCtx.isReferenced()) {
            this.validateLeafRefTargetNodeData((NormalizedNode)node, referencedByCtx, modificationType);
        }
        if (referencingCtx != null && referencingCtx.isReferencing()) {
            this.validateLeafRefNodeData((NormalizedNode)node, referencingCtx, modificationType, current);
        }
    }

    private void validateLeafSetNodeData(LeafSetNode<?> node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        if (referencedByCtx != null || referencingCtx != null) {
            for (LeafSetEntryNode leafSetEntry : node.body()) {
                if (referencedByCtx != null && referencedByCtx.isReferenced()) {
                    this.validateLeafRefTargetNodeData((NormalizedNode)leafSetEntry, referencedByCtx, modificationType);
                }
                if (referencingCtx == null || !referencingCtx.isReferencing()) continue;
                this.validateLeafRefNodeData((NormalizedNode)leafSetEntry, referencingCtx, modificationType, current);
            }
        }
    }

    private void validateChoiceNodeData(ChoiceNode node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        for (DataContainerChild child : node.body()) {
            LeafRefContext childReferencingCtx;
            QName qname = child.name().getNodeType();
            LeafRefContext childReferencedByCtx = referencedByCtx == null ? null : LeafRefValidation.findReferencedByCtxUnderChoice(referencedByCtx, qname);
            LeafRefContext leafRefContext = childReferencingCtx = referencingCtx == null ? null : LeafRefValidation.findReferencingCtxUnderChoice(referencingCtx, qname);
            if (childReferencedByCtx == null && childReferencingCtx == null) continue;
            this.validateNodeData((NormalizedNode)child, childReferencedByCtx, childReferencingCtx, modificationType, current.node((YangInstanceIdentifier.PathArgument)child.name()));
        }
    }

    private void validateDataContainerNodeData(DataContainerNode node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        for (DataContainerChild child : node.body()) {
            this.validateChildNodeData(child, referencedByCtx, referencingCtx, modificationType, current);
        }
    }

    private void validateMapNodeData(MapNode node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        for (MapEntryNode mapEntry : node.asMap().values()) {
            YangInstanceIdentifier mapEntryIdentifier = current.node((YangInstanceIdentifier.PathArgument)mapEntry.name());
            for (DataContainerChild child : mapEntry.body()) {
                this.validateChildNodeData(child, referencedByCtx, referencingCtx, modificationType, mapEntryIdentifier);
            }
        }
    }

    private void validateChildNodeData(DataContainerChild child, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        LeafRefContext childReferencingCtx;
        QName qname = child.name().getNodeType();
        LeafRefContext childReferencedByCtx = referencedByCtx == null ? null : referencedByCtx.getReferencedChildByName(qname);
        LeafRefContext leafRefContext = childReferencingCtx = referencingCtx == null ? null : referencingCtx.getReferencingChildByName(qname);
        if (childReferencedByCtx != null || childReferencingCtx != null) {
            this.validateNodeData((NormalizedNode)child, childReferencedByCtx, childReferencingCtx, modificationType, current.node((YangInstanceIdentifier.PathArgument)child.name()));
        }
    }

    private static LeafRefContext findReferencingCtxUnderChoice(LeafRefContext referencingCtx, QName qname) {
        for (LeafRefContext child : referencingCtx.getReferencingChilds().values()) {
            LeafRefContext referencingChildByName = child.getReferencingChildByName(qname);
            if (referencingChildByName == null) continue;
            return referencingChildByName;
        }
        return null;
    }

    private static LeafRefContext findReferencedByCtxUnderChoice(LeafRefContext referencedByCtx, QName qname) {
        for (LeafRefContext child : referencedByCtx.getReferencedByChilds().values()) {
            LeafRefContext referencedByChildByName = child.getReferencedChildByName(qname);
            if (referencedByChildByName == null) continue;
            return referencedByChildByName;
        }
        return null;
    }

    private void validateLeafRefTargetNodeData(NormalizedNode leaf, LeafRefContext referencedByCtx, ModificationType modificationType) {
        if (!this.validatedLeafRefCtx.add(referencedByCtx)) {
            LOG.trace("Operation [{}] validate data of leafref TARGET node: name[{}] = value[{}] -> SKIP: Already validated", new Object[]{modificationType, referencedByCtx.getNodeName(), leaf.body()});
            return;
        }
        LOG.trace("Operation [{}] validate data of leafref TARGET node: name[{}] = value[{}]", new Object[]{modificationType, referencedByCtx.getNodeName(), leaf.body()});
        Set<LeafRefContext> leafRefs = referencedByCtx.getAllReferencedByLeafRefCtxs().values().stream().filter(LeafRefContext::isReferencing).collect(Collectors.toSet());
        if (leafRefs.isEmpty()) {
            return;
        }
        Set<Object> leafRefTargetNodeValues = this.extractRootValues(referencedByCtx);
        leafRefs.forEach(leafRefContext -> this.extractRootValues((LeafRefContext)leafRefContext).forEach(leafRefsValue -> {
            if (leafRefTargetNodeValues.contains(leafRefsValue)) {
                LOG.trace("Valid leafref value [{}] {}", leafRefsValue, (Object)SUCCESS);
                return;
            }
            LOG.debug("Invalid leafref value [{}] allowed values {} by validation of leafref TARGET node: {} path of invalid LEAFREF node: {} leafRef target path: {} {}", new Object[]{leafRefsValue, leafRefTargetNodeValues, leaf.name(), leafRefContext.getCurrentNodePath(), leafRefContext.getAbsoluteLeafRefTargetPath(), FAILED});
            this.errorsMessages.add(String.format("Invalid leafref value [%s] allowed values %s by validation of leafref TARGET node: %s path of invalid LEAFREF node: %s leafRef target path: %s %s", leafRefsValue, leafRefTargetNodeValues, leaf.name(), leafRefContext.getCurrentNodePath(), leafRefContext.getAbsoluteLeafRefTargetPath(), FAILED));
        }));
    }

    private Set<Object> extractRootValues(LeafRefContext context) {
        return this.computeValues(this.root, LeafRefValidation.createPath(context.getLeafRefNodePath()), null);
    }

    private void validateLeafRefNodeData(NormalizedNode leaf, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        Set<Object> values = this.computeValues(this.root, LeafRefValidation.createPath(referencingCtx.getAbsoluteLeafRefTargetPath()), current);
        if (values.contains(leaf.body())) {
            LOG.debug("Operation [{}] validate data of LEAFREF node: name[{}] = value[{}] {}", new Object[]{modificationType, referencingCtx.getNodeName(), leaf.body(), SUCCESS});
            return;
        }
        LOG.debug("Operation [{}] validate data of LEAFREF node: name[{}] = value[{}] {}", new Object[]{modificationType, referencingCtx.getNodeName(), leaf.body(), FAILED});
        LOG.debug("Invalid leafref value [{}] allowed values {} of LEAFREF node: {} leafRef target path: {}", new Object[]{leaf.body(), values, leaf.name(), referencingCtx.getAbsoluteLeafRefTargetPath()});
        this.errorsMessages.add(String.format("Invalid leafref value [%s] allowed values %s of LEAFREF node: %s leafRef target path: %s", leaf.body(), values, leaf.name(), referencingCtx.getAbsoluteLeafRefTargetPath()));
    }

    private Set<Object> computeValues(NormalizedNode node, ArrayDeque<QNameWithPredicate> path, YangInstanceIdentifier current) {
        HashSet<Object> values = new HashSet<Object>();
        this.addValues(values, node, (List<QNamePredicate>)ImmutableList.of(), path, current);
        return values;
    }

    private void addValues(Set<Object> values, NormalizedNode node, List<QNamePredicate> nodePredicates, ArrayDeque<QNameWithPredicate> path, YangInstanceIdentifier current) {
        if (node instanceof ValueNode) {
            values.add(node.body());
            return;
        }
        if (node instanceof LeafSetNode) {
            LeafSetNode leafSet = (LeafSetNode)node;
            for (LeafSetEntryNode entry2 : leafSet.body()) {
                values.add(entry2.body());
            }
            return;
        }
        QNameWithPredicate next = path.peek();
        if (next == null) {
            return;
        }
        YangInstanceIdentifier.NodeIdentifier pathArgument = new YangInstanceIdentifier.NodeIdentifier(next.getQName());
        if (node instanceof DataContainerNode) {
            DataContainerNode dataContainer = (DataContainerNode)node;
            this.processChildNode(values, dataContainer, pathArgument, next.getQNamePredicates(), path, current);
        } else if (node instanceof MapNode) {
            MapNode map = (MapNode)node;
            Stream<Object> entries = map.body().stream();
            if (!nodePredicates.isEmpty() && current != null) {
                entries = entries.filter(this.createMapEntryPredicate(nodePredicates, current));
            }
            entries.forEach(entry -> this.processChildNode(values, (DataContainerNode)entry, pathArgument, next.getQNamePredicates(), path, current));
        }
    }

    private void processChildNode(Set<Object> values, DataContainerNode parent, YangInstanceIdentifier.NodeIdentifier arg, List<QNamePredicate> nodePredicates, ArrayDeque<QNameWithPredicate> path, YangInstanceIdentifier current) {
        DataContainerChild child = (DataContainerChild)parent.childByArg((YangInstanceIdentifier.PathArgument)arg);
        if (child == null) {
            for (DataContainerChild mixin : parent.body()) {
                if (!(mixin instanceof ChoiceNode)) continue;
                this.addValues(values, (NormalizedNode)mixin, nodePredicates, path, current);
            }
        } else {
            this.addNextValues(values, child, nodePredicates, path, current);
        }
    }

    private Predicate<MapEntryNode> createMapEntryPredicate(List<QNamePredicate> nodePredicates, YangInstanceIdentifier current) {
        HashMap keyValues = new HashMap();
        for (QNamePredicate predicate : nodePredicates) {
            keyValues.put((QName)predicate.getIdentifier(), this.getPathKeyExpressionValues(predicate.getPathKeyExpression(), current));
        }
        return mapEntry -> {
            for (Map.Entry entryKeyValue : mapEntry.name().entrySet()) {
                Set allowedValues = (Set)keyValues.get(entryKeyValue.getKey());
                if (allowedValues == null || allowedValues.contains(entryKeyValue.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNextValues(Set<Object> values, DataContainerChild node, List<QNamePredicate> nodePredicates, ArrayDeque<QNameWithPredicate> path, YangInstanceIdentifier current) {
        QNameWithPredicate element = path.pop();
        try {
            this.addValues(values, (NormalizedNode)node, nodePredicates, path, current);
        }
        finally {
            path.push(element);
        }
    }

    private Set<?> getPathKeyExpressionValues(LeafRefPath predicatePathKeyExpression, YangInstanceIdentifier current) {
        return LeafRefValidation.findParentNode(Optional.of(this.root), current).map(parent -> {
            ArrayDeque<QNameWithPredicate> path = LeafRefValidation.createPath(predicatePathKeyExpression);
            path.pollFirst();
            return this.computeValues((NormalizedNode)parent, path, null);
        }).orElse((Set)ImmutableSet.of());
    }

    private static Optional<NormalizedNode> findParentNode(Optional<NormalizedNode> root, YangInstanceIdentifier path) {
        Optional currentNode = root;
        Iterator pathIterator = path.getPathArguments().iterator();
        while (pathIterator.hasNext()) {
            YangInstanceIdentifier.PathArgument childPathArgument = (YangInstanceIdentifier.PathArgument)pathIterator.next();
            if (pathIterator.hasNext() && currentNode.isPresent()) {
                currentNode = NormalizedNodes.getDirectChild((NormalizedNode)currentNode.orElseThrow(), (YangInstanceIdentifier.PathArgument)childPathArgument);
                continue;
            }
            return currentNode;
        }
        return Optional.empty();
    }

    private static ArrayDeque<QNameWithPredicate> createPath(LeafRefPath path) {
        ArrayDeque<QNameWithPredicate> ret = new ArrayDeque<QNameWithPredicate>();
        path.getPathTowardsRoot().forEach(ret::push);
        return ret;
    }
}

