/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.base.MoreObjects;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.AbstractDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidateNodes;

abstract sealed class ReplacedDataTreeCandidateNode<T extends NormalizedNode>
extends AbstractDataTreeCandidateNode {
    private final @NonNull T dataBefore;
    private final @NonNull T dataAfter;

    private ReplacedDataTreeCandidateNode(T dataBefore, T dataAfter) {
        super(ModificationType.WRITE);
        this.dataBefore = (NormalizedNode)Objects.requireNonNull(dataBefore);
        this.dataAfter = (NormalizedNode)Objects.requireNonNull(dataAfter);
    }

    static @NonNull ReplacedDataTreeCandidateNode<?> of(NormalizedNode dataBefore, NormalizedNode dataAfter) {
        NormalizedNode normalizedNode = dataAfter;
        Objects.requireNonNull(normalizedNode);
        NormalizedNode normalizedNode2 = normalizedNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DistinctNodeContainer.class}, (Object)normalizedNode2, n)) {
            case 0 -> {
                DistinctNodeContainer container = (DistinctNodeContainer)normalizedNode2;
                yield new Container(dataBefore, container);
            }
            default -> new Leaf(dataBefore, dataAfter);
        };
    }

    public final YangInstanceIdentifier.PathArgument name() {
        return this.dataAfter.name();
    }

    public final @NonNull T dataBefore() {
        return this.dataBefore;
    }

    public final @NonNull T dataAfter() {
        return this.dataAfter;
    }

    @Override
    protected final MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("dataBefore", (Object)this.dataBefore.prettyTree()).add("dataAfter", (Object)this.dataAfter.prettyTree());
    }

    private static final class Container
    extends ReplacedDataTreeCandidateNode<DistinctNodeContainer> {
        Container(NormalizedNode dataBefore, DistinctNodeContainer<?, ?> dataAfter) {
            super((DistinctNodeContainer)dataBefore, dataAfter);
        }

        public Collection<DataTreeCandidateNode> childNodes() {
            return DataTreeCandidateNodes.containerDelta((DistinctNodeContainer)this.dataBefore(), (DistinctNodeContainer)this.dataAfter());
        }

        public DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument childName) {
            return DataTreeCandidateNodes.containerDelta((DistinctNodeContainer)this.dataBefore(), (DistinctNodeContainer)this.dataAfter(), Objects.requireNonNull(childName));
        }
    }

    private static final class Leaf
    extends ReplacedDataTreeCandidateNode<NormalizedNode> {
        Leaf(NormalizedNode dataBefore, NormalizedNode dataAfter) {
            super(dataBefore, dataAfter);
        }

        public List<DataTreeCandidateNode> childNodes() {
            return List.of();
        }

        public DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument childName) {
            return null;
        }
    }
}

