/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.AbstractDataTreeCandidateNode;

abstract sealed class UnmodifiedDataTreeCandidateNode<T extends NormalizedNode>
extends AbstractDataTreeCandidateNode {
    private final @NonNull T dataAfter;

    private UnmodifiedDataTreeCandidateNode(T dataAfter) {
        super(ModificationType.UNMODIFIED);
        this.dataAfter = (NormalizedNode)Objects.requireNonNull(dataAfter);
    }

    static @NonNull UnmodifiedDataTreeCandidateNode<?> of(NormalizedNode dataAfter) {
        NormalizedNode normalizedNode = dataAfter;
        Objects.requireNonNull(normalizedNode);
        NormalizedNode normalizedNode2 = normalizedNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DistinctNodeContainer.class}, (Object)normalizedNode2, n)) {
            case 0 -> {
                DistinctNodeContainer container = (DistinctNodeContainer)normalizedNode2;
                yield new Container(container);
            }
            default -> new Leaf(dataAfter);
        };
    }

    public final YangInstanceIdentifier.PathArgument name() {
        return this.dataAfter.name();
    }

    public final @NonNull T dataBefore() {
        return this.dataAfter;
    }

    public final @NonNull T dataAfter() {
        return this.dataAfter;
    }

    @Override
    protected final MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("dataAfter", (Object)this.dataAfter.prettyTree());
    }

    private static final class Container
    extends UnmodifiedDataTreeCandidateNode<DistinctNodeContainer> {
        Container(DistinctNodeContainer<?, ?> dataAfter) {
            super(dataAfter);
        }

        public Collection<DataTreeCandidateNode> childNodes() {
            return Container.childNodes((DistinctNodeContainer)this.dataAfter(), (Function<NormalizedNode, DataTreeCandidateNode>)((Function)UnmodifiedDataTreeCandidateNode::of));
        }

        public DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument childName) {
            return Container.modifiedChild((DistinctNodeContainer)this.dataAfter(), (Function<NormalizedNode, DataTreeCandidateNode>)((Function)UnmodifiedDataTreeCandidateNode::of), childName);
        }
    }

    private static final class Leaf
    extends UnmodifiedDataTreeCandidateNode<NormalizedNode> {
        Leaf(NormalizedNode dataAfter) {
            super(dataAfter);
        }

        public List<DataTreeCandidateNode> childNodes() {
            return List.of();
        }

        public DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument childName) {
            return null;
        }
    }
}

