/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.codec.AbstractIllegalArgumentCodec;

abstract class AbstractNamespaceCodec<T>
extends AbstractIllegalArgumentCodec<String, T> {
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');

    AbstractNamespaceCodec() {
    }

    protected abstract @Nullable String prefixForNamespace(@NonNull XMLNamespace var1);

    protected abstract @Nullable QName createQName(@NonNull String var1, @NonNull String var2);

    private static String getIdAndPrefixAsStr(String pathPart) {
        int predicateStartIndex = pathPart.indexOf(91);
        return predicateStartIndex == -1 ? pathPart : pathPart.substring(0, predicateStartIndex);
    }

    protected final @NonNull StringBuilder appendQName(StringBuilder sb, QName qname) {
        String prefix = this.prefixForNamespace(qname.getNamespace());
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (String)"Failed to map QName %s to prefix", (Object)qname);
        return sb.append(prefix).append(':').append(qname.getLocalName());
    }

    protected StringBuilder appendQName(StringBuilder sb, QName qname, @Nullable QNameModule lastModule) {
        return this.appendQName(sb, qname);
    }

    protected final QName parseQName(String str) {
        String identifier;
        String prefix;
        String xPathPartTrimmed = AbstractNamespaceCodec.getIdAndPrefixAsStr(str).trim();
        Iterator it = COLON_SPLITTER.split((CharSequence)xPathPartTrimmed).iterator();
        if (!it.hasNext()) {
            return null;
        }
        String first = ((String)it.next()).trim();
        if (first.isEmpty()) {
            return null;
        }
        if (it.hasNext()) {
            prefix = first;
            identifier = ((String)it.next()).trim();
        } else {
            prefix = "";
            identifier = first;
        }
        if (identifier.isEmpty()) {
            return null;
        }
        return this.createQName(prefix, identifier);
    }
}

