/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc7952.data.api.StreamWriterMetadataExtension;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;

@Beta
public class AnydataNodeDataWithSchema
extends SimpleNodeDataWithSchema<AnydataSchemaNode> {
    private Class<?> objectModel;

    public AnydataNodeDataWithSchema(AnydataSchemaNode dataSchemaNode) {
        super(dataSchemaNode);
    }

    public AnydataNodeDataWithSchema(AnydataSchemaNode dataSchemaNode, Class<?> objectModel) {
        super(dataSchemaNode);
        this.objectModel = Objects.requireNonNull(objectModel);
    }

    @Override
    public Object getValue() {
        return this.getObjectModel().cast(super.getValue());
    }

    @Override
    public void setValue(Object value) {
        Class<?> clazz = this.getObjectModel();
        Preconditions.checkArgument((boolean)clazz.isInstance(value), (String)"Value %s is not compatible with %s", clazz);
        super.setValue(value);
    }

    @Override
    protected void write(NormalizedNodeStreamWriter writer, StreamWriterMetadataExtension metaWriter) throws IOException {
        writer.nextDataSchemaNode(this.getSchema());
        if (writer.startAnydataNode(this.provideNodeIdentifier(), this.getObjectModel())) {
            writer.scalarValue(this.getValue());
            writer.endNode();
        }
    }

    public final @NonNull Class<?> getObjectModel() {
        Preconditions.checkState((this.objectModel != null ? 1 : 0) != 0, (Object)"Object model not set");
        return this.objectModel;
    }

    public void setObjectModel(Class<?> newObjectModel) {
        Preconditions.checkState((this.objectModel == null ? 1 : 0) != 0, (String)"Object model already set to %s", this.objectModel);
        this.objectModel = Objects.requireNonNull(newObjectModel);
    }
}

