/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.AbstractStringInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class XpathStringParsingPathArgumentBuilder
implements Mutable {
    private static final CharMatcher WSP = CharMatcher.anyOf((CharSequence)" \t");
    private static final CharMatcher IDENTIFIER_FIRST_CHAR = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.is((char)'_')).precomputed();
    private static final CharMatcher IDENTIFIER = IDENTIFIER_FIRST_CHAR.or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)".-")).precomputed();
    private static final CharMatcher QUOTE = CharMatcher.anyOf((CharSequence)"'\"");
    private static final char SLASH = '/';
    private static final char COLON = ':';
    private static final char DOT = '.';
    private static final char EQUALS = '=';
    private static final char PRECONDITION_START = '[';
    private static final char PRECONDITION_END = ']';
    private final List<YangInstanceIdentifier.PathArgument> product = new ArrayList<YangInstanceIdentifier.PathArgument>();
    private final AbstractStringInstanceIdentifierCodec codec;
    private final SchemaInferenceStack stack;
    private final String data;
    private DataSchemaContextNode<?> current;
    private QNameModule lastModule;
    private int offset;

    XpathStringParsingPathArgumentBuilder(AbstractStringInstanceIdentifierCodec codec, String data) {
        this.codec = Objects.requireNonNull(codec);
        this.data = Objects.requireNonNull(data);
        this.offset = 0;
        DataSchemaContextTree tree = codec.getDataContextTree();
        this.stack = SchemaInferenceStack.of((EffectiveModelContext)tree.getEffectiveModelContext());
        this.current = tree.getRoot();
    }

    @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.PathArgument> build() {
        while (!this.allCharactersConsumed()) {
            this.product.add(this.computeNextArgument());
        }
        return ImmutableList.copyOf(this.product);
    }

    private YangInstanceIdentifier.PathArgument computeNextArgument() {
        this.checkValid('/' == this.currentChar(), "Identifier must start with '/'.", new Object[0]);
        this.skipCurrentChar();
        this.checkValid(!this.allCharactersConsumed(), "Identifier cannot end with '/'.", new Object[0]);
        QName name = this.nextQName();
        this.lastModule = name.getModule();
        if (this.allCharactersConsumed() || '/' == this.currentChar()) {
            return this.computeIdentifier(name);
        }
        this.checkValid('[' == this.currentChar(), "Last element must be identifier, predicate or '/'", new Object[0]);
        return this.computeIdentifierWithPredicate(name);
    }

    private DataSchemaContextNode<?> nextContextNode(QName name) {
        this.current = this.current.getChild(name);
        this.checkValid(this.current != null, "%s is not correct schema node identifier.", name);
        while (this.current.isMixin()) {
            this.product.add((YangInstanceIdentifier.PathArgument)this.current.getIdentifier());
            this.current = this.current.getChild(name);
        }
        this.stack.enterDataTree(name);
        return this.current;
    }

    private YangInstanceIdentifier.PathArgument computeIdentifierWithPredicate(QName name) {
        DataSchemaContextNode<?> currentNode = this.nextContextNode(name);
        this.checkValid(currentNode.isKeyedEntry(), "Entry %s does not allow specifying predicates.", name);
        ImmutableMap.Builder keyValues = ImmutableMap.builder();
        while (!this.allCharactersConsumed() && '[' == this.currentChar()) {
            QName key;
            this.skipCurrentChar();
            this.skipWhitespaces();
            if ('.' == this.currentChar()) {
                key = null;
                this.skipCurrentChar();
            } else {
                key = this.nextQName();
            }
            this.skipWhitespaces();
            this.checkCurrentAndSkip('=', "Precondition must contain '='");
            this.skipWhitespaces();
            String keyValue = this.nextQuotedValue();
            this.skipWhitespaces();
            this.checkCurrentAndSkip(']', "Precondition must ends with ']'");
            if (key == null && currentNode.isLeaf()) {
                this.checkValid(this.offset == this.data.length(), "Leaf argument must be last argument of instance identifier.", new Object[0]);
                return new YangInstanceIdentifier.NodeWithValue(name, (Object)keyValue);
            }
            DataSchemaContextNode<?> keyNode = currentNode.getChild(key);
            this.checkValid(keyNode != null, "%s is not correct schema node identifier.", key);
            Object value = this.codec.deserializeKeyValue(keyNode.getDataSchemaNode(), type -> this.resolveLeafref(key, type), keyValue);
            keyValues.put((Object)key, value);
        }
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)name, (Map)keyValues.build());
    }

    private @NonNull TypeDefinition<?> resolveLeafref(QName qname, LeafrefTypeDefinition type) {
        SchemaInferenceStack tmp = this.stack.copy();
        tmp.enterDataTree(qname);
        return tmp.resolveLeafref(type);
    }

    private YangInstanceIdentifier.PathArgument computeIdentifier(QName name) {
        DataSchemaContextNode<?> currentNode = this.nextContextNode(name);
        this.checkValid(!currentNode.isKeyedEntry(), "Entry %s requires key or value predicate to be present", name);
        return (YangInstanceIdentifier.PathArgument)currentNode.getIdentifier();
    }

    private QName nextQName() {
        String maybePrefix = this.nextIdentifier();
        if (!this.allCharactersConsumed() && ':' == this.currentChar()) {
            this.skipCurrentChar();
            return this.codec.createQName(maybePrefix, this.nextIdentifier());
        }
        return this.codec.createQName(this.lastModule, maybePrefix);
    }

    private boolean allCharactersConsumed() {
        return this.offset == this.data.length();
    }

    private void checkCurrentAndSkip(char expected, String errorMsg) {
        this.checkValid(expected == this.currentChar(), errorMsg, new Object[0]);
        ++this.offset;
    }

    private void checkValid(boolean condition, String errorMsg, Object ... attributes) {
        if (!condition) {
            throw new IllegalArgumentException(String.format("Could not parse Instance Identifier '%s'. Offset: %s : Reason: %s", this.data, this.offset, String.format(errorMsg, attributes)));
        }
    }

    private String nextQuotedValue() {
        char quoteChar = this.currentChar();
        this.checkValid(QUOTE.matches(quoteChar), "Value must be qoute escaped with ''' or '\"'.", new Object[0]);
        this.skipCurrentChar();
        int valueStart = this.offset;
        int endQoute = this.data.indexOf(quoteChar, this.offset);
        String value = this.data.substring(valueStart, endQoute);
        this.offset = endQoute;
        this.skipCurrentChar();
        return value;
    }

    private char currentChar() {
        return this.data.charAt(this.offset);
    }

    private void skipCurrentChar() {
        ++this.offset;
    }

    private void skipWhitespaces() {
        this.nextSequenceEnd(WSP);
    }

    private String nextIdentifier() {
        this.checkValid(IDENTIFIER_FIRST_CHAR.matches(this.currentChar()), "Identifier must start with character from set 'a-zA-Z_'", new Object[0]);
        int start = this.offset;
        this.nextSequenceEnd(IDENTIFIER);
        return this.data.substring(start, this.offset);
    }

    private void nextSequenceEnd(CharMatcher matcher) {
        while (!this.allCharactersConsumed() && matcher.matches(this.data.charAt(this.offset))) {
            ++this.offset;
        }
    }
}

