/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.MountPointLabel;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContextFactory;
import org.opendaylight.yangtools.yang.data.util.AbstractMountPointContextFactory;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

record ImmutableMountPointContext(@NonNull EffectiveModelContext modelContext, @NonNull ImmutableMap<MountPointLabel, AbstractMountPointContextFactory.MountPointDefinition> mountPoints, @NonNull Function<AbstractMountPointContextFactory.MountPointDefinition, MountPointContextFactory> createFactory) implements Immutable,
MountPointContext
{
    ImmutableMountPointContext(@NonNull EffectiveModelContext modelContext, @NonNull ImmutableMap<MountPointLabel, AbstractMountPointContextFactory.MountPointDefinition> mountPoints, @NonNull Function<AbstractMountPointContextFactory.MountPointDefinition, MountPointContextFactory> createFactory) {
        Objects.requireNonNull(modelContext);
        Objects.requireNonNull(mountPoints);
        Objects.requireNonNull(createFactory);
    }

    ImmutableMountPointContext(EffectiveModelContext modelContext, Iterable<AbstractMountPointContextFactory.MountPointDefinition> mountPoints, Function<AbstractMountPointContextFactory.MountPointDefinition, MountPointContextFactory> createFactory) {
        this(modelContext, (ImmutableMap<MountPointLabel, AbstractMountPointContextFactory.MountPointDefinition>)Maps.uniqueIndex(mountPoints, AbstractMountPointContextFactory.MountPointDefinition::label), createFactory);
    }

    public Optional<MountPointContextFactory> findMountPoint(MountPointLabel label) {
        AbstractMountPointContextFactory.MountPointDefinition def = (AbstractMountPointContextFactory.MountPointDefinition)this.mountPoints.get((Object)Objects.requireNonNull(label));
        return def == null ? Optional.empty() : Optional.of(this.createFactory.apply(def));
    }
}

