/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.MountPointLabel;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointChild;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContextFactory;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointException;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class MountPointData {
    private static final Logger LOG = LoggerFactory.getLogger(MountPointData.class);
    private final Map<MountPointContextFactory.ContainerName, MountPointChild> yangLib = new EnumMap<MountPointContextFactory.ContainerName, MountPointChild>(MountPointContextFactory.ContainerName.class);
    private final List<MountPointChild> children = new ArrayList<MountPointChild>();
    private final MountPointContextFactory contextFactory;
    private final @NonNull MountPointLabel label;
    private MountPointChild schemaMounts;

    MountPointData(MountPointLabel label, MountPointContextFactory contextFactory) {
        this.label = Objects.requireNonNull(label);
        this.contextFactory = Objects.requireNonNull(contextFactory);
    }

    public @NonNull MountPointLabel label() {
        return this.label;
    }

    public void setContainer(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MountPointContextFactory.ContainerName containerName, @NonNull MountPointChild data) {
        MountPointChild prev = this.yangLib.putIfAbsent(containerName, Objects.requireNonNull(data));
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Attempted to duplicate container %s data %s with %s", (Object)containerName, (Object)prev, (Object)data);
        this.addChild(data);
    }

    public void setSchemaMounts(@NonNull MountPointChild data) {
        Preconditions.checkState((this.schemaMounts == null ? 1 : 0) != 0, (String)"Attempted to reset schema-mounts from %s to %s", (Object)this.schemaMounts, (Object)data);
        this.schemaMounts = Objects.requireNonNull(data);
        this.addChild(data);
    }

    public void addChild(@NonNull MountPointChild data) {
        this.children.add(Objects.requireNonNull(data));
    }

    void write(@NonNull NormalizedNodeStreamWriter writer) throws IOException {
        MountPointContext mountCtx;
        NormalizedNodeStreamWriter.MountPointExtension mountWriter = (NormalizedNodeStreamWriter.MountPointExtension)writer.extension(NormalizedNodeStreamWriter.MountPointExtension.class);
        if (mountWriter == null) {
            LOG.debug("Writer {} does not support mount points, ignoring data in {}", (Object)writer, (Object)this.label);
            return;
        }
        try {
            mountCtx = this.contextFactory.createContext(this.yangLib, this.schemaMounts);
        }
        catch (MountPointException e) {
            throw new IOException("Failed to resolve mount point " + String.valueOf(this.label), e);
        }
        try (NormalizedNodeStreamWriter nestedWriter = mountWriter.startMountPoint(this.label, mountCtx);){
            for (MountPointChild child : this.children) {
                child.writeTo(nestedWriter, mountCtx);
            }
        }
    }
}

