/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class NormalizedNodeStreamWriterStack
implements LeafrefResolver {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedNodeStreamWriterStack.class);
    private final Deque<EffectiveStatement<?, ?>> schemaStack = new ArrayDeque();
    private final SchemaInferenceStack dataTree;
    private final @NonNull Object root;

    private NormalizedNodeStreamWriterStack(EffectiveModelContext context) {
        this.dataTree = SchemaInferenceStack.of((EffectiveModelContext)context);
        this.root = Objects.requireNonNull(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NormalizedNodeStreamWriterStack(SchemaInferenceStack dataTree) {
        this.dataTree = Objects.requireNonNull(dataTree);
        if (!dataTree.isEmpty()) {
            EffectiveStatement current = dataTree.currentStatement();
            if (!(current instanceof DataTreeAwareEffectiveStatement)) throw new IllegalArgumentException("Cannot instantiate on " + String.valueOf(current));
            DataTreeAwareEffectiveStatement container = (DataTreeAwareEffectiveStatement)current;
            this.root = container;
            return;
        } else {
            this.root = dataTree.modelContext();
        }
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveStatementInference root) {
        return new NormalizedNodeStreamWriterStack(SchemaInferenceStack.ofInference((EffectiveStatementInference)root));
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(SchemaInferenceStack.Inference root) {
        return new NormalizedNodeStreamWriterStack(root.toSchemaInferenceStack());
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveModelContext context) {
        return new NormalizedNodeStreamWriterStack(context);
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveModelContext context, SchemaNodeIdentifier.Absolute path) {
        return new NormalizedNodeStreamWriterStack(SchemaInferenceStack.of((EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)path));
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveModelContext context, YangInstanceIdentifier path) {
        return new NormalizedNodeStreamWriterStack(((DataSchemaContextTree.NodeAndStack)DataSchemaContextTree.from(context).enterPath(path).orElseThrow()).stack());
    }

    public static @NonNull NormalizedNodeStreamWriterStack ofOperation(EffectiveModelContext context, SchemaNodeIdentifier.Absolute operation, QName qname) {
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)operation);
        EffectiveStatement current = stack.currentStatement();
        Preconditions.checkArgument((current instanceof RpcEffectiveStatement || current instanceof ActionEffectiveStatement ? 1 : 0) != 0, (String)"Path %s resolved into non-operation %s", (Object)operation, (Object)current);
        stack.enterSchemaTree(qname);
        return new NormalizedNodeStreamWriterStack(stack);
    }

    public TypeDefinition<?> resolveLeafref(LeafrefTypeDefinition type) {
        return this.dataTree.resolveLeafref(type);
    }

    public @Nullable EffectiveStatement<?, ?> currentStatement() {
        return this.schemaStack.peek();
    }

    private @NonNull Object currentStatementOrRoot() {
        EffectiveStatement<?, ?> stmt = this.currentStatement();
        return stmt != null ? stmt : this.root;
    }

    private @NonNull DataTreeEffectiveStatement<?> enterDataTree(YangInstanceIdentifier.PathArgument name) {
        QName qname = name.getNodeType();
        DataTreeEffectiveStatement stmt = this.dataTree.enterDataTree(qname);
        Object object = this.currentStatementOrRoot();
        if (object instanceof ChoiceEffectiveStatement) {
            ChoiceEffectiveStatement choice = (ChoiceEffectiveStatement)object;
            DataTreeEffectiveStatement check = choice.findDataTreeNode(qname).orElse(null);
            Verify.verify((check == stmt ? 1 : 0) != 0, (String)"Data tree result %s does not match choice result %s", (Object)stmt, (Object)check);
        }
        return stmt;
    }

    private <T extends DataTreeEffectiveStatement<?>> @NonNull T enterDataTree(YangInstanceIdentifier.PathArgument name, @NonNull Class<T> expectedClass, @NonNull String humanString) {
        DataTreeEffectiveStatement casted;
        DataTreeEffectiveStatement<?> schema = this.enterDataTree(name);
        try {
            casted = (DataTreeEffectiveStatement)expectedClass.cast(schema);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Node " + String.valueOf(schema) + " is not " + humanString, e);
        }
        this.schemaStack.push((EffectiveStatement<?, ?>)casted);
        return (T)casted;
    }

    public void startList(YangInstanceIdentifier.PathArgument name) {
        this.enterDataTree(name, ListEffectiveStatement.class, "a list");
    }

    public void startListItem(YangInstanceIdentifier.PathArgument name) throws IOException {
        Object parent = this.currentStatementOrRoot();
        if (!(parent instanceof ListEffectiveStatement)) {
            throw new IllegalArgumentException("List item is not appropriate under " + String.valueOf(parent));
        }
        ListEffectiveStatement parentList = (ListEffectiveStatement)parent;
        this.schemaStack.push((EffectiveStatement<?, ?>)parentList);
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.enterDataTree((YangInstanceIdentifier.PathArgument)name, LeafEffectiveStatement.class, "a leaf");
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name) {
        this.enterDataTree((YangInstanceIdentifier.PathArgument)name, LeafListEffectiveStatement.class, "a leaf-list");
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) {
        this.schemaStack.push((EffectiveStatement<?, ?>)this.leafSetEntryNode(name.getNodeType()));
    }

    private @NonNull LeafListEffectiveStatement leafSetEntryNode(QName qname) {
        EffectiveStatement<?, ?> parent = this.currentStatement();
        if (parent instanceof LeafListEffectiveStatement) {
            LeafListEffectiveStatement leafList = (LeafListEffectiveStatement)parent;
            return leafList;
        }
        if (parent instanceof DataTreeAwareEffectiveStatement) {
            DataTreeAwareEffectiveStatement parentContainer = (DataTreeAwareEffectiveStatement)parent;
            Object child = parentContainer.findDataTreeNode(qname).orElse(null);
            if (child instanceof LeafListEffectiveStatement) {
                LeafListEffectiveStatement childLeafList = child;
                return childLeafList;
            }
            throw new IllegalArgumentException("Node " + String.valueOf(child) + " is neither a leaf-list nor currently in a leaf-list");
        }
        throw new IllegalArgumentException("Cannot lookup " + String.valueOf(qname) + " in parent " + String.valueOf(parent));
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name) {
        LOG.debug("Enter choice {}", (Object)name);
        this.schemaStack.push((EffectiveStatement<?, ?>)this.dataTree.enterChoice(name.getNodeType()));
    }

    /*
     * Unable to fully structure code
     */
    public @NonNull DataTreeAwareEffectiveStatement<QName, ?> startContainerNode(YangInstanceIdentifier.NodeIdentifier name) {
        NormalizedNodeStreamWriterStack.LOG.debug("Enter container {}", (Object)name);
        if (!this.schemaStack.isEmpty() || !((var4_2 = this.root) instanceof NotificationEffectiveStatement)) ** GOTO lbl-1000
        notification = (NotificationEffectiveStatement)var4_2;
        if (name.getNodeType().equals(notification.argument())) {
            ret = notification;
        } else lbl-1000:
        // 2 sources

        {
            v0 = child = this.enterDataTree((YangInstanceIdentifier.PathArgument)name);
            Objects.requireNonNull(v0);
            var5_5 = v0;
            var6_6 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContainerEffectiveStatement.class, InputEffectiveStatement.class, OutputEffectiveStatement.class}, var5_5, var6_6)) {
                case 0: {
                    v1 = container = (ContainerEffectiveStatement)var5_5;
                    break;
                }
                case 1: {
                    input = (InputEffectiveStatement)var5_5;
                    v1 = input;
                    break;
                }
                case 2: {
                    output = (OutputEffectiveStatement)var5_5;
                    v1 = output;
                    break;
                }
                default: {
                    this.dataTree.exitToDataTree();
                    throw new IllegalArgumentException("Node " + String.valueOf(child) + " is not a container");
                }
            }
            ret = v1;
        }
        this.schemaStack.push((EffectiveStatement<?, ?>)ret);
        return ret;
    }

    public void startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.enterDataTree((YangInstanceIdentifier.PathArgument)name, AnyxmlEffectiveStatement.class, "anyxml");
    }

    public void startAnydataNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.enterDataTree((YangInstanceIdentifier.PathArgument)name, AnydataEffectiveStatement.class, "anydata");
    }

    public EffectiveStatement<?, ?> endNode() {
        EffectiveStatement<?, ?> ret = this.schemaStack.pop();
        if (this.currentStatement() != ret) {
            this.dataTree.exit();
        }
        return ret;
    }
}

