/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.base.Verify;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.TypeAwareCodec;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodecFactory<T extends TypeAwareCodec<?, ?, ?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCodecFactory.class);
    private final @NonNull EffectiveModelContext modelContext;
    private final @NonNull CodecCache<T> cache;

    protected AbstractCodecFactory(@NonNull EffectiveModelContext modelContext, @NonNull CodecCache<T> cache) {
        this.modelContext = Objects.requireNonNull(modelContext);
        this.cache = Objects.requireNonNull(cache);
    }

    public final <S extends TypeAware & SchemaNode> @NonNull T codecFor(S schema, LeafrefResolver resolver) {
        TypeDefinition type = schema.getType();
        TypeAwareCodec ret = (TypeAwareCodec)this.cache.lookupSimple(type);
        if (ret != null) {
            LOG.trace("Type {} hit simple {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = (TypeAwareCodec)this.cache.lookupComplex(schema);
        if (ret != null) {
            LOG.trace("Type {} hit complex {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = this.getSimpleCodecFor(type);
        if (ret != null) {
            LOG.trace("Type {} miss simple {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = this.createComplexCodecFor(schema, type, resolver);
        LOG.trace("Type {} miss complex {}", (Object)type, (Object)ret);
        return (T)this.cache.getComplex(schema, ret);
    }

    public final @NonNull EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    protected abstract T binaryCodec(BinaryTypeDefinition var1);

    protected abstract T booleanCodec(BooleanTypeDefinition var1);

    protected abstract T bitsCodec(BitsTypeDefinition var1);

    protected abstract T emptyCodec(EmptyTypeDefinition var1);

    protected abstract T enumCodec(EnumTypeDefinition var1);

    protected abstract T identityRefCodec(IdentityrefTypeDefinition var1, QNameModule var2);

    protected abstract T instanceIdentifierCodec(InstanceIdentifierTypeDefinition var1);

    public abstract @NonNull TypeAwareCodec<YangInstanceIdentifier, ?, ?> instanceIdentifierCodec();

    protected abstract T int8Codec(Int8TypeDefinition var1);

    protected abstract T int16Codec(Int16TypeDefinition var1);

    protected abstract T int32Codec(Int32TypeDefinition var1);

    protected abstract T int64Codec(Int64TypeDefinition var1);

    protected abstract T decimalCodec(DecimalTypeDefinition var1);

    protected abstract T stringCodec(StringTypeDefinition var1);

    protected abstract T uint8Codec(Uint8TypeDefinition var1);

    protected abstract T uint16Codec(Uint16TypeDefinition var1);

    protected abstract T uint32Codec(Uint32TypeDefinition var1);

    protected abstract T uint64Codec(Uint64TypeDefinition var1);

    protected abstract T unionCodec(UnionTypeDefinition var1, List<T> var2);

    private T getSimpleCodecFor(TypeDefinition<?> type) {
        TypeAwareCodec typeAwareCodec;
        if (type instanceof EmptyTypeDefinition) {
            EmptyTypeDefinition emptyType = (EmptyTypeDefinition)type;
            return this.emptyCodec(emptyType);
        }
        TypeDefinition<?> typeDefinition = type;
        Objects.requireNonNull(typeDefinition);
        TypeDefinition<?> typeDefinition2 = typeDefinition;
        int n = 0;
        block18: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BinaryTypeDefinition.class, BitsTypeDefinition.class, BooleanTypeDefinition.class, DecimalTypeDefinition.class, EnumTypeDefinition.class, InstanceIdentifierTypeDefinition.class, Int8TypeDefinition.class, Int16TypeDefinition.class, Int32TypeDefinition.class, Int64TypeDefinition.class, StringTypeDefinition.class, Uint8TypeDefinition.class, Uint16TypeDefinition.class, Uint32TypeDefinition.class, Uint64TypeDefinition.class, UnionTypeDefinition.class}, typeDefinition2, n)) {
                case 0: {
                    BinaryTypeDefinition binaryType = (BinaryTypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.binaryCodec(binaryType);
                    break block18;
                }
                case 1: {
                    BitsTypeDefinition bitsType = (BitsTypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.bitsCodec(bitsType);
                    break block18;
                }
                case 2: {
                    BooleanTypeDefinition booleanType = (BooleanTypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.booleanCodec(booleanType);
                    break block18;
                }
                case 3: {
                    DecimalTypeDefinition decimalType = (DecimalTypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.decimalCodec(decimalType);
                    break block18;
                }
                case 4: {
                    EnumTypeDefinition enumType = (EnumTypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.enumCodec(enumType);
                    break block18;
                }
                case 5: {
                    InstanceIdentifierTypeDefinition iidType = (InstanceIdentifierTypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.instanceIdentifierCodec(iidType);
                    break block18;
                }
                case 6: {
                    Int8TypeDefinition int8type = (Int8TypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.int8Codec(int8type);
                    break block18;
                }
                case 7: {
                    Int16TypeDefinition int16type = (Int16TypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.int16Codec(int16type);
                    break block18;
                }
                case 8: {
                    Int32TypeDefinition int32type = (Int32TypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.int32Codec(int32type);
                    break block18;
                }
                case 9: {
                    Int64TypeDefinition int64type = (Int64TypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.int64Codec(int64type);
                    break block18;
                }
                case 10: {
                    StringTypeDefinition stringType = (StringTypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.stringCodec(stringType);
                    break block18;
                }
                case 11: {
                    Uint8TypeDefinition uint8type = (Uint8TypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.uint8Codec(uint8type);
                    break block18;
                }
                case 12: {
                    Uint16TypeDefinition uint16type = (Uint16TypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.uint16Codec(uint16type);
                    break block18;
                }
                case 13: {
                    Uint32TypeDefinition uint32type = (Uint32TypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.uint32Codec(uint32type);
                    break block18;
                }
                case 14: {
                    Uint64TypeDefinition uint64type = (Uint64TypeDefinition)typeDefinition2;
                    typeAwareCodec = (TypeAwareCodec)this.uint64Codec(uint64type);
                    break block18;
                }
                case 15: {
                    UnionTypeDefinition unionType = (UnionTypeDefinition)typeDefinition2;
                    if (!AbstractCodecFactory.isSimpleUnion(unionType)) {
                        n = 16;
                        continue block18;
                    }
                    typeAwareCodec = (TypeAwareCodec)this.createSimpleUnion(unionType);
                    break block18;
                }
                default: {
                    typeAwareCodec = null;
                    break block18;
                }
            }
            break;
        }
        TypeAwareCodec ret = typeAwareCodec;
        return (T)(ret == null ? null : this.cache.getSimple(type, ret));
    }

    private static boolean isSimpleUnion(UnionTypeDefinition union) {
        for (TypeDefinition t : union.getTypes()) {
            UnionTypeDefinition unionType;
            if (!(t instanceof IdentityrefTypeDefinition) && !(t instanceof LeafrefTypeDefinition) && (!(t instanceof UnionTypeDefinition) || AbstractCodecFactory.isSimpleUnion(unionType = (UnionTypeDefinition)t))) continue;
            LOG.debug("Type {} has non-simple subtype", (Object)t);
            return false;
        }
        LOG.debug("Type {} is simple", (Object)union);
        return true;
    }

    private T createComplexCodecFor(SchemaNode schema, TypeDefinition<?> type, LeafrefResolver resolver) {
        TypeDefinition<?> typeDefinition = type;
        Objects.requireNonNull(typeDefinition);
        TypeDefinition<?> typeDefinition2 = typeDefinition;
        int n = 0;
        return (T)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentityrefTypeDefinition.class, LeafrefTypeDefinition.class, UnionTypeDefinition.class}, typeDefinition2, n)) {
            case 0 -> {
                IdentityrefTypeDefinition identityref = (IdentityrefTypeDefinition)typeDefinition2;
                yield (TypeAwareCodec)this.identityRefCodec(identityref, schema.getQName().getModule());
            }
            case 1 -> {
                LeafrefTypeDefinition leafref = (LeafrefTypeDefinition)typeDefinition2;
                TypeDefinition target = resolver.resolveLeafref(leafref);
                T ret = this.getSimpleCodecFor(target);
                yield (TypeAwareCodec)(ret != null ? ret : this.createComplexCodecFor(schema, target, resolver));
            }
            case 2 -> {
                UnionTypeDefinition union = (UnionTypeDefinition)typeDefinition2;
                yield (TypeAwareCodec)this.createComplexUnion(schema, union, resolver);
            }
            default -> throw new IllegalArgumentException("Unsupported type " + String.valueOf(type));
        });
    }

    private T createSimpleUnion(UnionTypeDefinition union) {
        List types = union.getTypes();
        ArrayList<TypeAwareCodec> codecs = new ArrayList<TypeAwareCodec>(types.size());
        for (TypeDefinition type : types) {
            TypeAwareCodec codec = (TypeAwareCodec)this.cache.lookupSimple(type);
            if (codec == null) {
                codec = (TypeAwareCodec)Verify.verifyNotNull(this.getSimpleCodecFor(type), (String)"Type %s did not resolve to a simple codec", (Object[])new Object[]{type});
            }
            codecs.add(codec);
        }
        return (T)this.unionCodec(union, codecs);
    }

    private T createComplexUnion(SchemaNode schema, UnionTypeDefinition union, LeafrefResolver resolver) {
        List types = union.getTypes();
        ArrayList<TypeAwareCodec> codecs = new ArrayList<TypeAwareCodec>(types.size());
        for (TypeDefinition type : types) {
            TypeAwareCodec codec = (TypeAwareCodec)this.cache.lookupSimple(type);
            if (codec == null && (codec = this.getSimpleCodecFor(type)) == null) {
                codec = this.createComplexCodecFor(schema, type, resolver);
            }
            codecs.add((TypeAwareCodec)Verify.verifyNotNull((Object)codec, (String)"Type %s has no codec", (Object[])new Object[]{schema, type}));
        }
        return (T)this.unionCodec(union, codecs);
    }
}

