/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.annotations.Beta;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.util.codec.QNameCodecUtil;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;

@Beta
@NonNullByDefault
public final class IdentityCodecUtil {
    private IdentityCodecUtil() {
    }

    public static IdentitySchemaNode parseIdentity(String value, EffectiveModelContext schemaContext, Function<String, QNameModule> prefixToModule) {
        QName qname = QNameCodecUtil.decodeQName(value, prefixToModule);
        Module module = (Module)schemaContext.findModule(qname.getModule()).orElseThrow(() -> new IllegalStateException("Parsed QName " + String.valueOf(qname) + " refers to a non-existent module"));
        for (IdentitySchemaNode identity : module.getIdentities()) {
            if (!qname.equals((Object)identity.getQName())) continue;
            return identity;
        }
        throw new IllegalArgumentException("Parsed QName " + String.valueOf(qname) + " does not refer to a valid identity");
    }
}

