/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.AnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AnydataNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.CompositeNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ContainerNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

@Beta
public abstract sealed class AbstractNodeDataWithSchema<T extends DataSchemaNode>
permits SimpleNodeDataWithSchema, CompositeNodeDataWithSchema {
    private final T schema;
    private ImmutableMap<QName, Object> attributes;

    AbstractNodeDataWithSchema(T schema) {
        this.schema = (DataSchemaNode)Objects.requireNonNull(schema);
    }

    public static @NonNull AbstractNodeDataWithSchema<?> of(DataSchemaNode schema) {
        DataSchemaNode dataSchemaNode = schema;
        Objects.requireNonNull(dataSchemaNode);
        DataSchemaNode dataSchemaNode2 = dataSchemaNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnyxmlSchemaNode.class, ContainerLike.class, LeafSchemaNode.class, ListSchemaNode.class, LeafListSchemaNode.class, AnydataSchemaNode.class}, (Object)dataSchemaNode2, n)) {
            case 0 -> {
                AnyxmlSchemaNode anyxml = (AnyxmlSchemaNode)dataSchemaNode2;
                yield new AnyXmlNodeDataWithSchema(anyxml);
            }
            case 1 -> {
                ContainerLike containerLike = (ContainerLike)dataSchemaNode2;
                yield new ContainerNodeDataWithSchema(containerLike);
            }
            case 2 -> {
                LeafSchemaNode leaf = (LeafSchemaNode)dataSchemaNode2;
                yield new LeafNodeDataWithSchema(leaf);
            }
            case 3 -> {
                ListSchemaNode list = (ListSchemaNode)dataSchemaNode2;
                yield new ListNodeDataWithSchema(list);
            }
            case 4 -> {
                LeafListSchemaNode leafList = (LeafListSchemaNode)dataSchemaNode2;
                yield new LeafListNodeDataWithSchema(leafList);
            }
            case 5 -> {
                AnydataSchemaNode anydata = (AnydataSchemaNode)dataSchemaNode2;
                yield new AnydataNodeDataWithSchema(anydata);
            }
            default -> throw new IllegalStateException("Unsupported schema " + String.valueOf(schema));
        };
    }

    public final @NonNull T getSchema() {
        return this.schema;
    }

    public final void setAttributes(ImmutableMap<QName, Object> attributes) {
        Preconditions.checkState((this.attributes == null ? 1 : 0) != 0, (String)"Node '%s' has already set its attributes to %s.", (Object)this.getSchema().getQName(), this.attributes);
        this.attributes = attributes;
    }

    public final ImmutableMap<QName, Object> getAttributes() {
        return this.attributes;
    }

    public final void write(NormalizedNodeStreamWriter writer) throws IOException {
        this.write(writer, (NormalizedNodeStreamWriter.MetadataExtension)writer.extension(NormalizedNodeStreamWriter.MetadataExtension.class));
    }

    protected abstract void write(NormalizedNodeStreamWriter var1, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable NormalizedNodeStreamWriter.MetadataExtension var2) throws IOException;

    protected final YangInstanceIdentifier.NodeIdentifier provideNodeIdentifier() {
        return YangInstanceIdentifier.NodeIdentifier.create((QName)this.schema.getQName());
    }

    protected final void writeMetadata(NormalizedNodeStreamWriter.MetadataExtension metaWriter) throws IOException {
        if (metaWriter != null && this.attributes != null && !this.attributes.isEmpty()) {
            metaWriter.metadata(this.attributes);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.schema);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNodeDataWithSchema other = (AbstractNodeDataWithSchema)obj;
        return this.schema.equals(other.schema);
    }
}

