/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.CheckedValue;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContext;
import org.opendaylight.yangtools.yang.data.util.impl.context.ContainerContext;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public final class DataSchemaContextTree {
    private static final LoadingCache<EffectiveModelContext, @NonNull DataSchemaContextTree> TREES = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<EffectiveModelContext, DataSchemaContextTree>(){

        public DataSchemaContextTree load(EffectiveModelContext key) {
            return new DataSchemaContextTree(key);
        }
    });
    private final @NonNull EffectiveModelContext modelContext;
    private final @NonNull ContainerContext root;

    private DataSchemaContextTree(EffectiveModelContext modelContext) {
        this.modelContext = Objects.requireNonNull(modelContext);
        this.root = new ContainerContext((ContainerLike)modelContext);
    }

    public static @NonNull DataSchemaContextTree from(@NonNull EffectiveModelContext ctx) {
        return (DataSchemaContextTree)TREES.getUnchecked((Object)ctx);
    }

    public @NonNull EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    public @Nullable DataSchemaContext childByPath(@NonNull YangInstanceIdentifier path) {
        return this.root.childByPath(path);
    }

    public @NonNull Optional<@NonNull DataSchemaContext> findChild(@NonNull YangInstanceIdentifier path) {
        DataSchemaContext child = this.root.childByPath(path);
        return child == null ? Optional.empty() : Optional.of(child);
    }

    public @NonNull CheckedValue<@NonNull NodeAndStack, @NonNull IllegalArgumentException> enterPath(YangInstanceIdentifier path) {
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)((EffectiveModelContext)this.root.dataSchemaNode()));
        ContainerContext node = this.root;
        for (YangInstanceIdentifier.PathArgument arg : path.getPathArguments()) {
            DataSchemaContext child;
            if (node instanceof DataSchemaContext.Composite) {
                DataSchemaContext.Composite composite = node;
                v0 = composite.enterChild(stack, arg);
            } else {
                v0 = child = null;
            }
            if (child == null) {
                return CheckedValue.ofException((Exception)new IllegalArgumentException("Failed to find " + String.valueOf(arg) + " in " + String.valueOf(node)));
            }
            node = child;
        }
        return CheckedValue.ofValue((Object)new NodeAndStack(node, stack));
    }

    public @NonNull DataSchemaContext.Composite getRoot() {
        return this.root;
    }

    public record NodeAndStack(@NonNull DataSchemaContext node, @NonNull SchemaInferenceStack stack) {
        public NodeAndStack(@NonNull DataSchemaContext node, @NonNull SchemaInferenceStack stack) {
            this.node = Objects.requireNonNull(node);
            this.stack = Objects.requireNonNull(stack);
        }
    }
}

