/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.ir;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.ir.AbstractIRObject;

@Beta
public abstract sealed class IRArgument
extends AbstractIRObject {
    private IRArgument() {
    }

    public static @NonNull Single empty() {
        return SingleQuoted.EMPTY;
    }

    public static @NonNull Single identifier(String string) {
        return new Identifier(string);
    }

    public static @NonNull Single singleQuoted(String string) {
        return new SingleQuoted(string);
    }

    public static @NonNull Single doubleQuoted(String string) {
        return new DoubleQuoted(string);
    }

    public static @NonNull Single unquoted(String string) {
        return new Unquoted(string);
    }

    public static @NonNull IRArgument of(List<Single> parts) {
        return switch (parts.size()) {
            case 0 -> IRArgument.empty();
            case 1 -> parts.get(0);
            default -> new Concatenation(parts);
        };
    }

    private static final class SingleQuoted
    extends Single {
        static final @NonNull SingleQuoted EMPTY = new SingleQuoted("");

        private SingleQuoted(String string) {
            super(string);
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            return super.toYangFragment(sb.append('\'')).append('\'');
        }
    }

    private static final class Identifier
    extends Single {
        private Identifier(String string) {
            super(string);
        }
    }

    private static final class DoubleQuoted
    extends Single {
        private DoubleQuoted(String string) {
            super(string);
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            return super.toYangFragment(sb.append('\"')).append('\"');
        }
    }

    private static final class Unquoted
    extends Single {
        private Unquoted(String string) {
            super(string);
        }
    }

    public static abstract sealed class Single
    extends IRArgument
    permits DoubleQuoted, SingleQuoted, Identifier, Unquoted {
        private final @NonNull String string;

        private Single(String string) {
            this.string = Objects.requireNonNull(string);
        }

        public final @NonNull String string() {
            return this.string;
        }

        public final boolean needUnescape() {
            return this instanceof DoubleQuoted;
        }

        public final boolean needQuoteCheck() {
            return this instanceof Unquoted;
        }

        public final boolean isValidIdentifier() {
            return this instanceof Identifier;
        }

        @Override
        public final int hashCode() {
            return this.string.hashCode();
        }

        @Override
        public final boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass().equals(obj.getClass()) && this.string.equals(((Single)obj).string);
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            return sb.append(this.string);
        }
    }

    public static final class Concatenation
    extends IRArgument {
        private final @NonNull ImmutableList<Single> parts;

        private Concatenation(List<Single> parts) {
            this.parts = ImmutableList.copyOf(parts);
        }

        public @NonNull List<? extends Single> parts() {
            return this.parts;
        }

        @Override
        public int hashCode() {
            return this.parts.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Concatenation)) return false;
            Concatenation other = (Concatenation)obj;
            if (!this.parts.equals(other.parts)) return false;
            return true;
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            UnmodifiableIterator it = this.parts.iterator();
            ((Single)it.next()).toYangFragment(sb);
            while (it.hasNext()) {
                ((Single)it.next()).toYangFragment(sb.append(" + "));
            }
            return sb;
        }
    }
}

