/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.plugin.generator.api.ModuleResourceResolver;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang2sources.plugin.Util;

final class ContextHolder
implements Immutable,
ModuleResourceResolver {
    private final EffectiveModelContext context;
    private final Set<Module> modules;
    private final Set<SourceIdentifier> sources;

    ContextHolder(EffectiveModelContext context, Set<Module> modules, Set<SourceIdentifier> sources) {
        this.context = Objects.requireNonNull(context);
        this.modules = ImmutableSet.copyOf(modules);
        this.sources = ImmutableSet.copyOf(sources);
    }

    public Optional<String> findModuleResourcePath(ModuleLike module, Class<? extends SchemaSourceRepresentation> representation) {
        Preconditions.checkArgument((boolean)YangTextSchemaSource.class.equals(Objects.requireNonNull(representation)), (String)"Unsupported representation %s", representation);
        SourceIdentifier id = Util.moduleToIdentifier(module);
        return this.sources.contains(id) ? Optional.of("/META-INF/yang/" + id.toYangFilename()) : Optional.empty();
    }

    EffectiveModelContext getContext() {
        return this.context;
    }

    Set<Module> getYangModules() {
        return this.modules;
    }
}

