/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.base.MoreObjects;
import org.apache.maven.project.MavenProject;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.plugin.generator.api.FileGenerator;
import org.opendaylight.yangtools.plugin.generator.api.FileGeneratorException;
import org.opendaylight.yangtools.plugin.generator.api.FileGeneratorFactory;
import org.opendaylight.yangtools.yang2sources.plugin.ContextHolder;
import org.opendaylight.yangtools.yang2sources.plugin.FileGeneratorArg;
import org.opendaylight.yangtools.yang2sources.plugin.FileGeneratorTask;
import org.opendaylight.yangtools.yang2sources.plugin.GeneratorTaskFactory;

final class FileGeneratorTaskFactory
extends GeneratorTaskFactory
implements Identifiable<String> {
    private final FileGeneratorArg arg;
    private final FileGenerator gen;

    private FileGeneratorTaskFactory(FileGenerator gen, FileGeneratorArg arg) {
        super(gen.importResolutionMode());
        this.arg = arg;
        this.gen = gen;
    }

    static FileGeneratorTaskFactory of(FileGeneratorFactory factory, FileGeneratorArg arg) throws FileGeneratorException {
        return new FileGeneratorTaskFactory(factory.newFileGenerator(arg.getConfiguration()), arg);
    }

    public String getIdentifier() {
        return this.arg.getIdentifier();
    }

    FileGeneratorTask createTask(MavenProject project, ContextHolder context) {
        return new FileGeneratorTask(this, context, project);
    }

    FileGenerator generator() {
        return this.gen;
    }

    @Override
    MoreObjects.ToStringHelper addToStringProperties(MoreObjects.ToStringHelper helper) {
        return super.addToStringProperties(helper).add("argument", (Object)this.arg);
    }
}

