/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.api.Submodule;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.api.YangParser;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang2sources.plugin.ContextHolder;
import org.opendaylight.yangtools.yang2sources.plugin.ScannedDependency;
import org.opendaylight.yangtools.yang2sources.plugin.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProcessorModuleReactor {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorModuleReactor.class);
    private final Map<SourceIdentifier, YangTextSchemaSource> modelsInProject;
    private final Collection<ScannedDependency> dependencies;
    private YangParser parser;

    ProcessorModuleReactor(YangParser parser, Collection<YangTextSchemaSource> modelsInProject, Collection<ScannedDependency> dependencies) {
        this.parser = Objects.requireNonNull(parser);
        this.modelsInProject = Maps.uniqueIndex(modelsInProject, YangTextSchemaSource::getIdentifier);
        this.dependencies = ImmutableList.copyOf(dependencies);
    }

    ContextHolder toContext() throws IOException, YangParserException {
        Preconditions.checkState((this.parser != null ? 1 : 0) != 0, (Object)"Context has already been assembled");
        for (YangTextSchemaSource source : ProcessorModuleReactor.toUniqueSources(this.dependencies)) {
            this.parser.addLibSource((SchemaSourceRepresentation)source);
        }
        EffectiveModelContext schemaContext = (EffectiveModelContext)Verify.verifyNotNull((Object)this.parser.buildEffectiveModel());
        this.parser = null;
        HashSet<Module> modules = new HashSet<Module>();
        for (Module module : schemaContext.getModules()) {
            SourceIdentifier modId = Util.moduleToIdentifier((ModuleLike)module);
            LOG.debug("Looking for source {}", (Object)modId);
            if (!this.modelsInProject.containsKey(modId)) continue;
            LOG.debug("Module {} belongs to current project", (Object)module);
            modules.add(module);
            for (Submodule sub : module.getSubmodules()) {
                SourceIdentifier subId = Util.moduleToIdentifier((ModuleLike)sub);
                if (this.modelsInProject.containsKey(subId)) continue;
                LOG.warn("Submodule {} not found in input files", (Object)sub);
            }
        }
        return new ContextHolder(schemaContext, modules, this.modelsInProject.keySet());
    }

    Collection<YangTextSchemaSource> getModelsInProject() {
        return this.modelsInProject.values();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/600")
    private static Collection<YangTextSchemaSource> toUniqueSources(Collection<ScannedDependency> dependencies) throws IOException {
        HashMap<String, YangTextSchemaSource> byContent = new HashMap<String, YangTextSchemaSource>();
        for (ScannedDependency dependency : dependencies) {
            for (YangTextSchemaSource s : dependency.sources()) {
                Reader reader = s.asCharSource(StandardCharsets.UTF_8).openStream();
                try {
                    String contents = CharStreams.toString((Readable)reader);
                    byContent.putIfAbsent(contents, s);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        return byContent.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sources", this.modelsInProject.keySet()).toString();
    }
}

