/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.project.MavenProject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang2sources.plugin.Util;
import org.opendaylight.yangtools.yang2sources.plugin.YangToSourcesProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
abstract class ScannedDependency {
    private static final Logger LOG = LoggerFactory.getLogger(ScannedDependency.class);
    private final File file;

    ScannedDependency(File file) {
        this.file = Objects.requireNonNull(file);
    }

    static Collection<ScannedDependency> scanDependencies(MavenProject project) throws IOException {
        List<File> filesOnCp = Util.getClassPath(project);
        LOG.debug("{} Searching for YANG files in dependencies: {}", (Object)"yang-to-sources:", filesOnCp);
        LOG.debug("{} Searching for YANG files in {} dependencies", (Object)"yang-to-sources:", (Object)filesOnCp.size());
        ArrayList<ScannedDependency> result = new ArrayList<ScannedDependency>();
        for (File file : filesOnCp) {
            if (file.isDirectory()) {
                File yangDir = new File(file, YangToSourcesProcessor.META_INF_YANG_STRING);
                if (!yangDir.exists() || !yangDir.isDirectory()) continue;
                result.addAll(ScannedDependency.scanDirectory(yangDir));
                continue;
            }
            result.addAll(ScannedDependency.scanZipFile(file));
        }
        return result;
    }

    private static Collection<ScannedDependency> scanDirectory(File yangDir) {
        return (Collection)Arrays.stream(yangDir.listFiles((dir, name) -> name.endsWith(".yang") && new File(dir, name).isFile())).map(Single::new).collect(ImmutableList.toImmutableList());
    }

    private static Collection<ScannedDependency> scanZipFile(File zipFile) throws IOException {
        Collection entryNames;
        try (ZipFile zip = new ZipFile(zipFile);){
            entryNames = (Collection)zip.stream().filter(entry -> {
                String entryName = entry.getName();
                return entryName.startsWith("META-INF/yang") && !entry.isDirectory() && entryName.endsWith(".yang");
            }).map(ZipEntry::getName).collect(ImmutableList.toImmutableList());
        }
        return entryNames.isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)new Zip(zipFile, entryNames));
    }

    final File file() {
        return this.file;
    }

    abstract Collection<YangTextSchemaSource> sources() throws IOException;

    private static final class Zip
    extends ScannedDependency {
        private final Set<String> entryNames;

        Zip(File file, Collection<String> entryNames) {
            super(file);
            this.entryNames = ImmutableSet.copyOf(entryNames);
        }

        @Override
        Collection<YangTextSchemaSource> sources() throws IOException {
            ArrayList<YangTextSchemaSource> result = new ArrayList<YangTextSchemaSource>(this.entryNames.size());
            try (ZipFile zip = new ZipFile(this.file());){
                for (String entryName : this.entryNames) {
                    ZipEntry entry = Objects.requireNonNull(zip.getEntry(entryName));
                    result.add(YangTextSchemaSource.delegateForByteSource((String)entryName.substring(entryName.lastIndexOf(47) + 1), (ByteSource)ByteSource.wrap((byte[])ByteStreams.toByteArray((InputStream)zip.getInputStream(entry)))));
                }
            }
            return result;
        }
    }

    private static final class Single
    extends ScannedDependency {
        Single(File file) {
            super(file);
        }

        @Override
        Collection<YangTextSchemaSource> sources() {
            return ImmutableList.of((Object)YangTextSchemaSource.forPath((Path)this.file().toPath()));
        }
    }
}

