/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractModelStatement<A>
implements ModelStatement<A> {
    AbstractModelStatement() {
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("argument", this.argument());
    }

    protected static final @NonNull Object maskList(ImmutableList<?> list) {
        return list.size() == 1 ? list.get(0) : list;
    }

    protected static final <T> @NonNull ImmutableList<T> unmaskList(@NonNull Object masked, @NonNull Class<T> type) {
        return masked instanceof ImmutableList ? (ImmutableList)masked : ImmutableList.of(type.cast(masked));
    }

    protected static final @NonNull Object maskSet(ImmutableSet<?> set) {
        return set.size() == 1 ? set.iterator().next() : set;
    }

    protected static final <T> @NonNull ImmutableSet<T> unmaskSet(@NonNull Object masked, @NonNull Class<T> type) {
        return masked instanceof ImmutableSet ? (ImmutableSet)masked : ImmutableSet.of(type.cast(masked));
    }
}

