/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.ArgumentDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;

@Beta
@NonNullByDefault
public abstract class AbstractStatementDefinition
implements StatementDefinition {
    private final QName statementName;
    private final @Nullable QName argumentName;
    private final boolean yinElement;

    protected AbstractStatementDefinition(QName statementName) {
        this(statementName, false, null);
    }

    protected AbstractStatementDefinition(QName statementName, boolean yinElement, @Nullable QName argumentName) {
        this.statementName = Objects.requireNonNull(statementName);
        this.yinElement = yinElement;
        this.argumentName = argumentName;
    }

    @Override
    public final QName getStatementName() {
        return this.statementName;
    }

    @Override
    public final Optional<ArgumentDefinition> getArgumentDefinition() {
        return ArgumentDefinition.ofNullable(this.argumentName, this.yinElement);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        helper.add("name", (Object)this.statementName);
        if (this.argumentName != null) {
            helper.add("argument", (Object)this.argumentName).add("yin-element", this.yinElement);
        }
        return helper;
    }
}

