/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementEquivalent;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeRoot;

@Beta
public interface EffectiveModelContext
extends SchemaContext,
SchemaTreeRoot {
    public @NonNull Map<QNameModule, ModuleEffectiveStatement> getModuleStatements();

    default public @NonNull Optional<ModuleEffectiveStatement> findModuleStatement(QNameModule moduleName) {
        return Optional.ofNullable(this.getModuleStatements().get(Objects.requireNonNull(moduleName)));
    }

    default public @NonNull Optional<ModuleEffectiveStatement> findModuleStatement(QName moduleName) {
        return this.findModuleStatement(moduleName.getModule());
    }

    default public @NonNull Collection<@NonNull ModuleEffectiveStatement> findModuleStatements(String name) {
        return Collections2.transform(this.findModules(name), EffectiveStatementEquivalent::asEffectiveStatement);
    }

    default public @NonNull Collection<@NonNull ModuleEffectiveStatement> findModuleStatements(XMLNamespace namespace) {
        return Collections2.transform(this.findModules(namespace), EffectiveStatementEquivalent::asEffectiveStatement);
    }

    default public @NonNull ModuleEffectiveStatement getModuleStatement(QNameModule moduleName) {
        return (ModuleEffectiveStatement)Verify.verifyNotNull((Object)this.getModuleStatements().get(Objects.requireNonNull(moduleName)));
    }

    default public @NonNull ModuleEffectiveStatement getModuleStatement(QName moduleName) {
        return this.getModuleStatement(moduleName.getModule());
    }

    @Override
    default public Optional<SchemaTreeEffectiveStatement<?>> findSchemaTreeNode(SchemaNodeIdentifier path) {
        return this.findModuleStatement(path.firstNodeIdentifier().getModule()).flatMap(module -> module.findSchemaTreeNode(path));
    }
}

