/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLikeCompat;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.InputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.OutputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

final class OperationAsContainer
extends ContainerLikeCompat {
    private final @NonNull OperationDefinition delegate;

    OperationAsContainer(OperationDefinition parentNode) {
        this.delegate = Objects.requireNonNull(parentNode);
    }

    @Override
    public OperationDefinition delegate() {
        return this.delegate;
    }

    @Override
    public Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
        return this.delegate.getTypeDefinitions();
    }

    @Override
    public Collection<? extends GroupingDefinition> getGroupings() {
        return this.delegate.getGroupings();
    }

    @Override
    public DataSchemaNode dataChildByName(QName name) {
        InputSchemaNode input = this.delegate.getInput();
        if (name.equals((Object)input.getQName())) {
            return input;
        }
        OutputSchemaNode output = this.delegate.getOutput();
        if (name.equals((Object)output.getQName())) {
            return output;
        }
        return null;
    }

    public Set<AugmentationSchemaNode> getAvailableAugmentations() {
        return Set.of();
    }

    public List<DataSchemaNode> getChildNodes() {
        return List.of(this.delegate.getInput(), this.delegate.getOutput());
    }
}

