/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;

final class ModuleNamespaceContext
implements NamespaceContext {
    private static final Map.Entry<String, String> YIN_PREFIX_AND_NAMESPACE = Map.entry("", "urn:ietf:params:xml:ns:yang:yin:1");
    private final ListMultimap<@NonNull String, @NonNull String> namespaceToPrefix;
    private final ModuleEffectiveStatement module;

    ModuleNamespaceContext(ModuleEffectiveStatement module) {
        this.module = Objects.requireNonNull(module);
        ImmutableListMultimap.Builder namespaces = ImmutableListMultimap.builder();
        for (Map.Entry entry : module.namespacePrefixes()) {
            namespaces.put((Object)((QNameModule)entry.getKey()).getNamespace().toString(), (Object)((String)entry.getValue()));
        }
        this.namespaceToPrefix = namespaces.build();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0);
        return switch (prefix) {
            case "" -> "urn:ietf:params:xml:ns:yang:yin:1";
            case "xml" -> "http://www.w3.org/XML/1998/namespace";
            case "xmlns" -> "http://www.w3.org/2000/xmlns/";
            default -> this.module.findReachableModule(prefix).map(importedModule -> importedModule.localQNameModule().getNamespace().toString()).orElse("");
        };
    }

    @Override
    public String getPrefix(String namespaceURI) {
        Preconditions.checkArgument((namespaceURI != null ? 1 : 0) != 0);
        return switch (namespaceURI) {
            case "urn:ietf:params:xml:ns:yang:yin:1" -> "";
            case "http://www.w3.org/XML/1998/namespace" -> "xml";
            case "http://www.w3.org/2000/xmlns/" -> "xmlns";
            default -> {
                List prefixes = this.namespaceToPrefix.get((Object)namespaceURI);
                if (prefixes.isEmpty()) {
                    yield null;
                }
                yield (String)prefixes.get(0);
            }
        };
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        Preconditions.checkArgument((namespaceURI != null ? 1 : 0) != 0);
        return switch (namespaceURI) {
            case "urn:ietf:params:xml:ns:yang:yin:1" -> Iterators.singletonIterator((Object)"");
            case "http://www.w3.org/XML/1998/namespace" -> Iterators.singletonIterator((Object)"xml");
            case "http://www.w3.org/2000/xmlns/" -> Iterators.singletonIterator((Object)"xmlns");
            default -> this.namespaceToPrefix.get((Object)namespaceURI).iterator();
        };
    }

    Map.Entry<String, String> prefixAndNamespaceFor(QNameModule namespace) {
        if (YangConstants.RFC6020_YIN_MODULE.equals((Object)namespace)) {
            return YIN_PREFIX_AND_NAMESPACE;
        }
        String prefix = (String)this.module.findNamespacePrefix(namespace).orElseThrow(() -> new IllegalArgumentException("Module " + namespace + " does not map to a prefix"));
        return Map.entry(prefix, namespace.getNamespace().toString());
    }

    Collection<Map.Entry<String, ModuleEffectiveStatement>> importedModules() {
        return this.module.reachableModules();
    }
}

