/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.AbstractLeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.EmptyLeafListEffectiveStatement;

abstract class AbstractNonEmptyLeafListEffectiveStatement
extends AbstractLeafListEffectiveStatement {
    private final @Nullable ElementCountConstraint elementCountConstraint;
    private final @NonNull QName argument;

    AbstractNonEmptyLeafListEffectiveStatement(LeafListStatement declared, QName argument, int flags, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, ElementCountConstraint elementCountConstraint) {
        super(declared, flags, substatements);
        this.argument = Objects.requireNonNull(argument);
        this.elementCountConstraint = elementCountConstraint;
    }

    AbstractNonEmptyLeafListEffectiveStatement(AbstractNonEmptyLeafListEffectiveStatement originalEffecive, QName argument, int flags) {
        super(originalEffecive, flags);
        this.argument = Objects.requireNonNull(argument);
        this.elementCountConstraint = originalEffecive.elementCountConstraint;
    }

    AbstractNonEmptyLeafListEffectiveStatement(EmptyLeafListEffectiveStatement originalEffective, QName argument, int flags) {
        super(originalEffective, flags);
        this.argument = Objects.requireNonNull(argument);
        this.elementCountConstraint = null;
    }

    public final QName argument() {
        return this.argument;
    }

    public final Optional<ElementCountConstraint> getElementCountConstraint() {
        return Optional.ofNullable(this.elementCountConstraint);
    }
}

