/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.AbstractListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.EmptyListEffectiveStatement;

public final class RegularListEffectiveStatement
extends AbstractListEffectiveStatement {
    private final ElementCountConstraint elementCountConstraint;
    private final @NonNull QName argument;

    public RegularListEffectiveStatement(ListStatement declared, QName argument, int flags, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, ImmutableList<QName> keyDefinition, ElementCountConstraint elementCountConstraint) {
        super(declared, flags, substatements, keyDefinition);
        this.argument = Objects.requireNonNull(argument);
        this.elementCountConstraint = elementCountConstraint;
    }

    public RegularListEffectiveStatement(RegularListEffectiveStatement originalEffective, QName argument, int flags) {
        super(originalEffective, flags);
        this.argument = Objects.requireNonNull(argument);
        this.elementCountConstraint = originalEffective.elementCountConstraint;
    }

    public RegularListEffectiveStatement(EmptyListEffectiveStatement originalEffective, QName argument, int flags) {
        super(originalEffective, flags);
        this.argument = Objects.requireNonNull(argument);
        this.elementCountConstraint = null;
    }

    public QName argument() {
        return this.argument;
    }

    public Optional<ElementCountConstraint> getElementCountConstraint() {
        return Optional.ofNullable(this.elementCountConstraint);
    }
}

