/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedTypeBuilder;

@Beta
public abstract class ConcreteTypeBuilder<T extends TypeDefinition<T>>
extends DerivedTypeBuilder<T> {
    ConcreteTypeBuilder(T baseType, QName qname) {
        super(baseType, qname);
        this.setStatus(baseType.getStatus());
        baseType.getDescription().ifPresent(this::setDescription);
        baseType.getReference().ifPresent(this::setReference);
    }

    abstract @NonNull T buildType();

    @Override
    public final T build() {
        Object base = this.getBaseType();
        if (Objects.equals(this.getDefaultValue(), base.getDefaultValue().orElse(null)) && Objects.equals(this.getUnits(), base.getUnits().orElse(null))) {
            return base;
        }
        return (T)((TypeDefinition)Verify.verifyNotNull(this.buildType()));
    }
}

