/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.UnresolvedNumber;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueRange;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.LengthRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.AbstractRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.InvalidLengthConstraintException;
import org.opendaylight.yangtools.yang.model.ri.type.NumberUtil;
import org.opendaylight.yangtools.yang.model.ri.type.ResolvedLengthConstraint;

public abstract class LengthRestrictedTypeBuilder<T extends LengthRestrictedTypeDefinition<T>>
extends AbstractRestrictedTypeBuilder<T> {
    private LengthConstraint lengthConstraint;

    LengthRestrictedTypeBuilder(T baseType, QName qname) {
        super((LengthRestrictedTypeDefinition)Objects.requireNonNull(baseType), qname);
    }

    public final void setLengthConstraint(@NonNull ConstraintMetaDefinition constraint, @NonNull List<ValueRange> ranges) throws InvalidLengthConstraintException {
        Preconditions.checkState((this.lengthConstraint == null ? 1 : 0) != 0, (String)"Length constraint already defined as %s", (Object)this.lengthConstraint);
        LengthConstraint baseLengths = this.findLenghts();
        if (ranges.isEmpty()) {
            this.lengthConstraint = baseLengths;
            return;
        }
        Objects.requireNonNull(constraint);
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        Range span = baseLengths.getAllowedRanges().span();
        for (ValueRange c : ranges) {
            builder.add(Range.closed((Comparable)LengthRestrictedTypeBuilder.resolveLength(c.lowerBound(), (Range<Integer>)span), (Comparable)LengthRestrictedTypeBuilder.resolveLength(c.upperBound(), (Range<Integer>)span)));
        }
        ImmutableRangeSet allowed = builder.build();
        RangeSet baseRanges = baseLengths.getAllowedRanges();
        for (Range range : allowed.asRanges()) {
            if (baseRanges.encloses(range)) continue;
            throw new InvalidLengthConstraintException("Range %s is not a subset of parent constraint %s", range, baseRanges);
        }
        this.lengthConstraint = new ResolvedLengthConstraint(constraint, (RangeSet<Integer>)allowed);
        this.touch();
    }

    abstract @NonNull T buildType(LengthConstraint var1);

    @Override
    final T buildType() {
        return this.buildType(this.lengthConstraint != null ? this.lengthConstraint : this.findLenghts());
    }

    abstract LengthConstraint typeLengthConstraints();

    private static Integer resolveLength(Number unresolved, Range<Integer> span) {
        if (unresolved instanceof Integer) {
            return (Integer)unresolved;
        }
        if (unresolved instanceof UnresolvedNumber) {
            return (Integer)((UnresolvedNumber)unresolved).resolveLength(span);
        }
        return (Integer)((Function)Verify.verifyNotNull(NumberUtil.converterTo(Integer.class))).apply(unresolved);
    }

    private LengthConstraint findLenghts() {
        Optional ret = Optional.empty();
        for (LengthRestrictedTypeDefinition wlk = (LengthRestrictedTypeDefinition)this.getBaseType(); wlk != null && ret.isEmpty(); wlk = (LengthRestrictedTypeDefinition)wlk.getBaseType()) {
            ret = wlk.getLengthConstraint();
        }
        return ret.orElse(this.typeLengthConstraints());
    }
}

