/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

final class NumberUtil {
    private static final Comparator<Number> NUMBER_COMPARATOR = (o1, o2) -> {
        Preconditions.checkArgument((boolean)o1.getClass().equals(o2.getClass()), (String)"Incompatible Number classes %s and %s", o1.getClass(), o2.getClass());
        Number number = o1;
        Objects.requireNonNull(number);
        Number selector0$temp = number;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Uint8.class, Uint16.class, Uint32.class, Uint64.class, Decimal64.class}, (Object)selector0$temp, index$1)) {
            case 0 -> {
                Byte b = (Byte)selector0$temp;
                yield b.compareTo((Byte)o2);
            }
            case 1 -> {
                Short s = (Short)selector0$temp;
                yield s.compareTo((Short)o2);
            }
            case 2 -> {
                Integer i = (Integer)selector0$temp;
                yield i.compareTo((Integer)o2);
            }
            case 3 -> {
                Long l = (Long)selector0$temp;
                yield l.compareTo((Long)o2);
            }
            case 4 -> {
                Uint8 u8 = (Uint8)selector0$temp;
                yield u8.compareTo((Uint8)o2);
            }
            case 5 -> {
                Uint16 u16 = (Uint16)selector0$temp;
                yield u16.compareTo((Uint16)o2);
            }
            case 6 -> {
                Uint32 u32 = (Uint32)selector0$temp;
                yield u32.compareTo((Uint32)o2);
            }
            case 7 -> {
                Uint64 u64 = (Uint64)selector0$temp;
                yield u64.compareTo((Uint64)o2);
            }
            case 8 -> {
                Decimal64 d64 = (Decimal64)selector0$temp;
                yield d64.compareTo((Decimal64)o2);
            }
            default -> throw new IllegalArgumentException("Unsupported Number class " + String.valueOf(o1.getClass()));
        };
    };
    private static final ImmutableMap<Class<? extends Number>, Function<Number, Number>> CONVERTERS;

    private NumberUtil() {
    }

    static <T extends Number> Function<Number, T> converterTo(Class<T> clazz) {
        return (Function)CONVERTERS.get(clazz);
    }

    static boolean isRangeCovered(Number min, Number max, Number superMin, Number superMax) {
        return NUMBER_COMPARATOR.compare(min, superMin) >= 0 && NUMBER_COMPARATOR.compare(max, superMax) <= 0;
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put(Byte.class, input -> {
            Byte val;
            return input instanceof Byte ? (val = (Byte)input) : Byte.valueOf(input.toString());
        });
        b.put(Short.class, input -> {
            Number number = input;
            Objects.requireNonNull(number);
            Number selector0$temp = number;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Short.class, Byte.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    Short val;
                    yield val = (Short)selector0$temp;
                }
                case 1 -> {
                    Byte val = (Byte)selector0$temp;
                    yield val.shortValue();
                }
                default -> Short.valueOf(input.toString());
            };
        });
        b.put(Integer.class, input -> {
            Number number = input;
            Objects.requireNonNull(number);
            Number selector0$temp = number;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Short.class, Byte.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    Integer val;
                    yield val = (Integer)selector0$temp;
                }
                case 1 -> {
                    Short val = (Short)selector0$temp;
                    yield val.intValue();
                }
                case 2 -> {
                    Byte val = (Byte)selector0$temp;
                    yield val.intValue();
                }
                default -> Integer.valueOf(input.toString());
            };
        });
        b.put(Long.class, input -> {
            Number number = input;
            Objects.requireNonNull(number);
            Number selector0$temp = number;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Integer.class, Short.class, Byte.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    Long val;
                    yield val = (Long)selector0$temp;
                }
                case 1 -> {
                    Integer val = (Integer)selector0$temp;
                    yield val.longValue();
                }
                case 2 -> {
                    Short val = (Short)selector0$temp;
                    yield val.longValue();
                }
                case 3 -> {
                    Byte val = (Byte)selector0$temp;
                    yield val.longValue();
                }
                default -> Long.valueOf(input.toString());
            };
        });
        b.put(Decimal64.class, input -> {
            if (input instanceof Decimal64) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long) {
                return Decimal64.valueOf((int)1, (long)input.longValue());
            }
            return Decimal64.valueOf((String)input.toString());
        });
        b.put(Uint8.class, input -> {
            if (input instanceof Uint8) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long || input instanceof Uint16 || input instanceof Uint32 || input instanceof Uint64) {
                return Uint8.valueOf((long)input.longValue());
            }
            return Uint8.valueOf((String)input.toString());
        });
        b.put(Uint16.class, input -> {
            if (input instanceof Uint16) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long || input instanceof Uint8 || input instanceof Uint32 || input instanceof Uint64) {
                return Uint16.valueOf((long)input.longValue());
            }
            return Uint16.valueOf((String)input.toString());
        });
        b.put(Uint32.class, input -> {
            if (input instanceof Uint32) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long || input instanceof Uint8 || input instanceof Uint16 || input instanceof Uint64) {
                return Uint32.valueOf((long)input.longValue());
            }
            return Uint32.valueOf((String)input.toString());
        });
        b.put(Uint64.class, input -> {
            if (input instanceof Uint64) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long || input instanceof Uint8 || input instanceof Uint16 || input instanceof Uint32) {
                return Uint64.valueOf((long)input.longValue());
            }
            return Uint64.valueOf((String)input.toString());
        });
        CONVERTERS = b.build();
    }
}

