/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

public abstract class AbstractSchemaContext
implements SchemaContext {
    public static final Comparator<Module> REVISION_COMPARATOR = (first, second) -> Revision.compare((Optional)second.getRevision(), (Optional)first.getRevision());
    public static final Comparator<Module> NAME_REVISION_COMPARATOR = (first, second) -> {
        int cmp = first.getName().compareTo(second.getName());
        return cmp != 0 ? cmp : REVISION_COMPARATOR.compare((Module)first, (Module)second);
    };
    private static final VarHandle DERIVED_IDENTITIES;
    private volatile ImmutableMap<IdentitySchemaNode, ImmutableSet<IdentitySchemaNode>> derivedIdentities = null;

    protected static final TreeSet<Module> createModuleSet() {
        return new TreeSet<Module>(REVISION_COMPARATOR);
    }

    protected abstract SetMultimap<XMLNamespace, Module> getNamespaceToModules();

    protected abstract SetMultimap<String, Module> getNameToModules();

    protected abstract Map<QNameModule, Module> getModuleMap();

    public Collection<? extends DataSchemaNode> getDataDefinitions() {
        HashSet dataDefs = new HashSet();
        for (Module m : this.getModules()) {
            dataDefs.addAll(m.getChildNodes());
        }
        return dataDefs;
    }

    public Collection<? extends NotificationDefinition> getNotifications() {
        HashSet notifications = new HashSet();
        for (Module m : this.getModules()) {
            notifications.addAll(m.getNotifications());
        }
        return notifications;
    }

    public Collection<? extends RpcDefinition> getOperations() {
        HashSet rpcs = new HashSet();
        for (Module m : this.getModules()) {
            rpcs.addAll(m.getRpcs());
        }
        return rpcs;
    }

    public Collection<? extends ExtensionDefinition> getExtensions() {
        HashSet extensions = new HashSet();
        for (Module m : this.getModules()) {
            extensions.addAll(m.getExtensionSchemaNodes());
        }
        return extensions;
    }

    public Optional<? extends Module> findModule(String name, Optional<Revision> revision) {
        for (Module module : this.getNameToModules().get((Object)name)) {
            if (!revision.equals(module.getRevision())) continue;
            return Optional.of(module);
        }
        return Optional.empty();
    }

    public Optional<Module> findModule(QNameModule qnameModule) {
        return Optional.ofNullable(this.getModuleMap().get(qnameModule));
    }

    public Collection<? extends Module> findModules(XMLNamespace namespace) {
        return this.getNamespaceToModules().get((Object)namespace);
    }

    public Collection<? extends Module> findModules(String name) {
        return this.getNameToModules().get((Object)name);
    }

    public Collection<? extends UnknownSchemaNode> getUnknownSchemaNodes() {
        ArrayList result = new ArrayList();
        for (Module module : this.getModules()) {
            result.addAll(module.getUnknownSchemaNodes());
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.getModules()) {
            result.addAll(module.getTypeDefinitions());
        }
        return Collections.unmodifiableSet(result);
    }

    public Collection<? extends DataSchemaNode> getChildNodes() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.getModules()) {
            result.addAll(module.getChildNodes());
        }
        return Collections.unmodifiableSet(result);
    }

    public Collection<? extends GroupingDefinition> getGroupings() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.getModules()) {
            result.addAll(module.getGroupings());
        }
        return Collections.unmodifiableSet(result);
    }

    public DataSchemaNode dataChildByName(QName name) {
        Objects.requireNonNull(name);
        for (Module module : this.getModules()) {
            DataSchemaNode result = module.dataChildByName(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Collection<? extends IdentitySchemaNode> getDerivedIdentities(IdentitySchemaNode identity) {
        ImmutableSet result;
        ImmutableMap<IdentitySchemaNode, ImmutableSet<IdentitySchemaNode>> local = DERIVED_IDENTITIES.getAcquire(this);
        if (local == null) {
            local = this.loadDerivedIdentities();
        }
        if ((result = (ImmutableSet)local.get((Object)Objects.requireNonNull(identity))) == null) {
            throw new IllegalArgumentException("Identity " + identity + " not found");
        }
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private ImmutableMap<IdentitySchemaNode, ImmutableSet<IdentitySchemaNode>> loadDerivedIdentities() {
        SetMultimap tmp = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
        ArrayList identities = new ArrayList();
        for (Object module : this.getModules()) {
            @NonNull Collection ids = module.getIdentities();
            for (IdentitySchemaNode identity : ids) {
                for (IdentitySchemaNode base : identity.getBaseIdentities()) {
                    tmp.put((Object)base, (Object)identity);
                }
            }
            identities.addAll(ids);
        }
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)identities.size());
        for (IdentitySchemaNode identity : identities) {
            builder.put((Object)identity, (Object)ImmutableSet.copyOf((Collection)tmp.get((Object)identity)));
        }
        ImmutableMap result = builder.build();
        Object witness = DERIVED_IDENTITIES.compareAndExchangeRelease(this, null, result);
        return witness == null ? result : (ImmutableMap)witness;
    }

    static {
        try {
            DERIVED_IDENTITIES = MethodHandles.lookup().findVarHandle(AbstractSchemaContext.class, "derivedIdentities", ImmutableMap.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

