/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.source;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.spi.source.AbstractYangTextSource;

@NonNullByDefault
public class URLYangTextSource
extends AbstractYangTextSource<URL> {
    private final Charset charset;

    public URLYangTextSource(SourceIdentifier sourceId, URL url, Charset charset) {
        super(sourceId, url);
        this.charset = Objects.requireNonNull(charset);
    }

    public URLYangTextSource(URL url) {
        this(SourceIdentifier.ofYangFileName((String)URLYangTextSource.extractFileName(url.getPath())), url, StandardCharsets.UTF_8);
    }

    public final Reader openStream() throws IOException {
        return new InputStreamReader(((URL)this.getDelegate()).openStream(), this.charset);
    }

    public final @NonNull String symbolicName() {
        return ((URL)this.getDelegate()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("url", this.getDelegate());
    }

    private static String extractFileName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }
}

