/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import java.util.Collection;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.repo.DependencyResolver;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangModelDependencyInfo;

final class RevisionDependencyResolver
extends DependencyResolver {
    RevisionDependencyResolver(Map<SourceIdentifier, YangModelDependencyInfo> depInfo) {
        super(depInfo);
    }

    protected static SourceIdentifier findWildcard(Iterable<SourceIdentifier> haystack, UnresolvedQName.Unqualified needle) {
        for (SourceIdentifier r : haystack) {
            if (!needle.equals((Object)r.name())) continue;
            return r;
        }
        return null;
    }

    @Override
    YangParserConfiguration parserConfig() {
        return YangParserConfiguration.DEFAULT;
    }

    @Override
    protected boolean isKnown(Collection<SourceIdentifier> haystack, ModuleImport mi) {
        SourceIdentifier msi = new SourceIdentifier(mi.getModuleName(), (Revision)mi.getRevision().orElse(null));
        if (haystack.contains(msi)) {
            return true;
        }
        return mi.getRevision().isEmpty() && RevisionDependencyResolver.findWildcard(haystack, mi.getModuleName()) != null;
    }

    public static RevisionDependencyResolver create(Map<SourceIdentifier, YangModelDependencyInfo> depInfo) {
        return new RevisionDependencyResolver(depInfo);
    }
}

