/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupportBundle;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.validation.ValidationBundles;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.BuildGlobalContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.EffectiveSchemaContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReactorDeclaredModel;

public final class CrossSourceStatementReactor {
    private final ImmutableMap<ModelProcessingPhase, StatementSupportBundle> supportedTerminology;
    private final ImmutableMap<ValidationBundles.ValidationBundleType, Collection<?>> supportedValidation;

    CrossSourceStatementReactor(Map<ModelProcessingPhase, StatementSupportBundle> supportedTerminology, Map<ValidationBundles.ValidationBundleType, Collection<?>> supportedValidation) {
        this.supportedTerminology = ImmutableMap.copyOf(supportedTerminology);
        this.supportedValidation = ImmutableMap.copyOf(supportedValidation);
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public @NonNull BuildAction newBuild() {
        return new BuildAction(this.supportedTerminology, this.supportedValidation);
    }

    public static class Builder
    implements Mutable {
        private final Map<ValidationBundles.ValidationBundleType, Collection<?>> validationBundles = new EnumMap(ValidationBundles.ValidationBundleType.class);
        private final Map<ModelProcessingPhase, StatementSupportBundle> bundles = new EnumMap<ModelProcessingPhase, StatementSupportBundle>(ModelProcessingPhase.class);

        public @NonNull Builder setBundle(ModelProcessingPhase phase, StatementSupportBundle bundle) {
            this.bundles.put(phase, bundle);
            return this;
        }

        public @NonNull Builder setValidationBundle(ValidationBundles.ValidationBundleType type, Collection<?> validationBundle) {
            this.validationBundles.put(type, validationBundle);
            return this;
        }

        public @NonNull CrossSourceStatementReactor build() {
            return new CrossSourceStatementReactor(this.bundles, this.validationBundles);
        }
    }

    public static final class BuildAction {
        private final BuildGlobalContext context;
        private boolean supportedFeaturesSet = false;
        private boolean modulesDeviatedByModulesSet = false;

        BuildAction(ImmutableMap<ModelProcessingPhase, StatementSupportBundle> supportedTerminology, ImmutableMap<ValidationBundles.ValidationBundleType, Collection<?>> supportedValidation) {
            this.context = new BuildGlobalContext(supportedTerminology, supportedValidation);
        }

        public @NonNull BuildAction addSource(StatementStreamSource source) {
            this.context.addSource(source);
            return this;
        }

        public @NonNull BuildAction addSources(StatementStreamSource ... sources) {
            this.addSources(Arrays.asList(sources));
            return this;
        }

        public @NonNull BuildAction addSources(@NonNull Collection<? extends StatementStreamSource> sources) {
            for (StatementStreamSource statementStreamSource : sources) {
                this.context.addSource(Objects.requireNonNull(statementStreamSource));
            }
            return this;
        }

        public @NonNull BuildAction addLibSource(StatementStreamSource libSource) {
            this.context.addLibSource(libSource);
            return this;
        }

        public @NonNull BuildAction addLibSources(StatementStreamSource ... libSources) {
            this.addLibSources(Arrays.asList(libSources));
            return this;
        }

        public @NonNull BuildAction addLibSources(Collection<StatementStreamSource> libSources) {
            for (StatementStreamSource libSource : libSources) {
                this.context.addLibSource(libSource);
            }
            return this;
        }

        public @NonNull BuildAction setSupportedFeatures(@NonNull Set<QName> supportedFeatures) {
            Preconditions.checkState((!this.supportedFeaturesSet ? 1 : 0) != 0, (Object)"Supported features should be set only once.");
            this.context.setSupportedFeatures(Objects.requireNonNull(supportedFeatures));
            this.supportedFeaturesSet = true;
            return this;
        }

        public @NonNull BuildAction setModulesWithSupportedDeviations(@NonNull SetMultimap<QNameModule, QNameModule> modulesDeviatedByModules) {
            Preconditions.checkState((!this.modulesDeviatedByModulesSet ? 1 : 0) != 0, (Object)"Modules with supported deviations should be set only once.");
            this.context.setModulesDeviatedByModules(Objects.requireNonNull(modulesDeviatedByModules));
            this.modulesDeviatedByModulesSet = true;
            return this;
        }

        public ReactorDeclaredModel build() throws ReactorException {
            return this.context.build();
        }

        public EffectiveSchemaContext buildEffective() throws ReactorException {
            return this.context.buildEffective();
        }
    }
}

