/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.VirtualNamespaceContext;

abstract class NamespaceBehaviourWithListeners<K, V>
extends NamespaceBehaviour<K, V> {
    protected final NamespaceBehaviour<K, V> delegate;
    private List<VirtualNamespaceContext<?, V, K>> derivedNamespaces;

    protected NamespaceBehaviourWithListeners(NamespaceBehaviour<K, V> delegate) {
        super((ParserNamespace)delegate.getIdentifier());
        this.delegate = delegate;
    }

    abstract void addListener(KeyedValueAddedListener<K> var1);

    abstract void addListener(PredicateValueAddedListener<K, V> var1);

    public abstract void addTo(NamespaceBehaviour.NamespaceStorageNode var1, K var2, V var3);

    protected void notifyListeners(NamespaceBehaviour.NamespaceStorageNode storage, Iterator<? extends KeyedValueAddedListener<K>> keyListeners, V value) {
        ArrayList<KeyedValueAddedListener<K>> toNotify = new ArrayList<KeyedValueAddedListener<K>>();
        while (keyListeners.hasNext()) {
            KeyedValueAddedListener<K> listener = keyListeners.next();
            if (!listener.isRequestedValue(this, storage, value)) continue;
            keyListeners.remove();
            toNotify.add(listener);
        }
        for (KeyedValueAddedListener keyedValueAddedListener : toNotify) {
            keyedValueAddedListener.onValueAdded(value);
        }
    }

    protected void notifyDerivedNamespaces(NamespaceBehaviour.NamespaceStorageNode storage, K key, V value) {
        if (this.derivedNamespaces != null) {
            for (VirtualNamespaceContext<?, V, K> derived : this.derivedNamespaces) {
                derived.addedToSourceNamespace(storage, key, value);
            }
        }
    }

    final void addDerivedNamespace(VirtualNamespaceContext<?, V, K> namespace) {
        if (this.derivedNamespaces == null) {
            this.derivedNamespaces = new ArrayList();
        }
        this.derivedNamespaces.add(namespace);
    }

    public V getFrom(NamespaceBehaviour.NamespaceStorageNode storage, K key) {
        return (V)this.delegate.getFrom(storage, key);
    }

    public Map<K, V> getAllFrom(NamespaceBehaviour.NamespaceStorageNode storage) {
        return this.delegate.getAllFrom(storage);
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper).add("delegate", this.delegate);
    }

    static abstract class KeyedValueAddedListener<K>
    extends ValueAddedListener<K> {
        private final K key;

        KeyedValueAddedListener(NamespaceBehaviour.NamespaceStorageNode contextNode, K key) {
            super(contextNode);
            this.key = Objects.requireNonNull(key);
        }

        final K getKey() {
            return this.key;
        }

        final <V> boolean isRequestedValue(NamespaceBehaviour<K, ?> behavior, NamespaceBehaviour.NamespaceStorageNode storage, V value) {
            return value == behavior.getFrom(this.getCtxNode(), this.key);
        }

        abstract void onValueAdded(Object var1);
    }

    static abstract class PredicateValueAddedListener<K, V>
    extends ValueAddedListener<K> {
        PredicateValueAddedListener(NamespaceBehaviour.NamespaceStorageNode contextNode) {
            super(contextNode);
        }

        abstract boolean onValueAdded(@NonNull K var1, @NonNull V var2);
    }

    static abstract class ValueAddedListener<K> {
        private final NamespaceBehaviour.NamespaceStorageNode ctxNode;

        ValueAddedListener(NamespaceBehaviour.NamespaceStorageNode contextNode) {
            this.ctxNode = Objects.requireNonNull(contextNode);
        }

        final NamespaceBehaviour.NamespaceStorageNode getCtxNode() {
            return this.ctxNode;
        }
    }
}

