/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.ArgumentDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.ImplicitParentAwareStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.OverrideChildStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class StatementDefinitionContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> {
    private final @NonNull StatementSupport<A, D, E> support;
    private final Map<String, StatementDefinitionContext<?, ?, ?>> argumentSpecificSubDefinitions;
    private Map<StatementDefinitionContext<?, ?, ?>, StatementDefinitionContext<?, ?, ?>> unknownStmtDefsOfYangStmts;

    StatementDefinitionContext(StatementSupport<A, D, E> support) {
        this.support = Objects.requireNonNull(support);
        this.argumentSpecificSubDefinitions = support.hasArgumentSpecificSupports() ? new HashMap() : null;
    }

    @NonNull StatementFactory<A, D, E> getFactory() {
        return this.support;
    }

    A parseArgumentValue(StmtContext<A, D, E> context, String value) {
        return (A)this.support.parseArgumentValue(context, value);
    }

    A adaptArgumentValue(StmtContext<A, D, E> context, QNameModule targetModule) {
        return (A)this.support.adaptArgumentValue(context, targetModule);
    }

    @NonNull StatementDefinition getPublicView() {
        return this.support.getPublicView();
    }

    Optional<StatementSupport<?, ?, ?>> getImplicitParentFor(NamespaceStmtCtx parent, StatementDefinition stmtDef) {
        Optional optional;
        StatementSupport<A, D, E> statementSupport = this.support;
        if (statementSupport instanceof ImplicitParentAwareStatementSupport) {
            ImplicitParentAwareStatementSupport implicit = (ImplicitParentAwareStatementSupport)statementSupport;
            optional = implicit.getImplicitParentFor(parent, stmtDef);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    void onStatementAdded(StmtContext.Mutable<A, D, E> stmt) {
        this.support.onStatementAdded(stmt);
    }

    void onDeclarationFinished(StmtContext.Mutable<A, D, E> statement, ModelProcessingPhase phase) {
        switch (phase) {
            case SOURCE_PRE_LINKAGE: {
                this.support.onPreLinkageDeclared(statement);
                break;
            }
            case SOURCE_LINKAGE: {
                this.support.onLinkageDeclared(statement);
                break;
            }
            case STATEMENT_DEFINITION: {
                this.support.onStatementDefinitionDeclared(statement);
                break;
            }
            case FULL_DECLARATION: {
                this.support.onFullDefinitionDeclared(statement);
                break;
            }
        }
    }

    @NonNull Optional<ArgumentDefinition> getArgumentDefinition() {
        return this.support.getArgumentDefinition();
    }

    @NonNull QName getStatementName() {
        return this.support.statementName();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statement", (Object)this.getStatementName()).toString();
    }

    @NonNull StatementDefinitionContext<?, ?, ?> getSubDefinitionSpecificForArgument(String argument) {
        if (!this.hasArgumentSpecificSubDefinitions()) {
            return this;
        }
        StatementDefinitionContext<A, D, E> potential = this.argumentSpecificSubDefinitions.get(argument);
        if (potential == null) {
            StatementSupport argumentSpecificSupport = this.support.getSupportSpecificForArgument(argument);
            potential = argumentSpecificSupport != null ? new StatementDefinitionContext<A, D, E>(argumentSpecificSupport) : this;
            this.argumentSpecificSubDefinitions.put(argument, potential);
        }
        return potential;
    }

    StatementSupport<A, D, E> support() {
        return this.support;
    }

    boolean hasArgumentSpecificSubDefinitions() {
        return this.support.hasArgumentSpecificSupports();
    }

    @NonNull StatementDefinitionContext<?, ?, ?> overrideDefinition(@NonNull StatementDefinitionContext<?, ?, ?> def) {
        StatementSupport override;
        if (!(this.support instanceof OverrideChildStatementSupport)) {
            return def;
        }
        if (this.unknownStmtDefsOfYangStmts != null) {
            StatementDefinitionContext<?, ?, ?> existing = this.unknownStmtDefsOfYangStmts.get(def);
            if (existing != null) {
                return existing;
            }
        } else {
            this.unknownStmtDefsOfYangStmts = new HashMap(4);
        }
        StatementDefinitionContext<Object, Object, Object> ret = (override = ((OverrideChildStatementSupport)this.support).statementDefinitionOverrideOf(def.getPublicView())) != null ? new StatementDefinitionContext<A, D, E>(override) : def;
        this.unknownStmtDefsOfYangStmts.put(def, ret);
        return ret;
    }
}

