/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.namespace;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ModuleQNameToPrefix;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class StmtNamespaceContext
implements YangNamespaceContext {
    private static final long serialVersionUID = 1L;
    private final ImmutableBiMap<QNameModule, String> moduleToPrefix;
    private final ImmutableMap<String, QNameModule> prefixToModule;

    StmtNamespaceContext(StmtContext<?, ?, ?> ctx) {
        Map belongsTo;
        Map qnameToPrefix = ctx.getAllFromNamespace(ModuleQNameToPrefix.INSTANCE);
        this.moduleToPrefix = qnameToPrefix == null ? ImmutableBiMap.of() : ImmutableBiMap.copyOf((Map)qnameToPrefix);
        HashMap<String, QNameModule> additional = new HashMap<String, QNameModule>();
        Map imports = ctx.getAllFromNamespace(ParserNamespaces.IMPORT_PREFIX_TO_MODULECTX);
        if (imports != null) {
            for (Map.Entry entry : imports.entrySet()) {
                if (this.moduleToPrefix.containsValue(entry.getKey())) continue;
                QNameModule qnameModule = (QNameModule)ctx.getFromNamespace(ParserNamespaces.MODULECTX_TO_QNAME, (Object)((StmtContext)entry.getValue()));
                if (qnameModule == null && ctx.producesDeclared(SubmoduleStatement.class)) {
                    qnameModule = (QNameModule)ctx.getFromNamespace(ParserNamespaces.MODULE_NAME_TO_QNAME, (Object)((UnresolvedQName.Unqualified)ctx.getFromNamespace(ParserNamespaces.BELONGSTO_PREFIX_TO_MODULE_NAME, entry.getKey())));
                }
                if (qnameModule == null) continue;
                additional.put((String)entry.getKey(), qnameModule);
            }
        }
        if (ctx.producesDeclared(SubmoduleStatement.class) && (belongsTo = ctx.getAllFromNamespace(ParserNamespaces.BELONGSTO_PREFIX_TO_MODULE_NAME)) != null) {
            for (Map.Entry entry : belongsTo.entrySet()) {
                QNameModule module = (QNameModule)ctx.getFromNamespace(ParserNamespaces.MODULE_NAME_TO_QNAME, (Object)((UnresolvedQName.Unqualified)entry.getValue()));
                if (module == null || additional.containsKey(entry.getKey())) continue;
                additional.put((String)entry.getKey(), module);
            }
        }
        this.prefixToModule = ImmutableMap.copyOf(additional);
    }

    public Optional<String> findPrefixForNamespace(QNameModule namespace) {
        return Optional.ofNullable((String)this.moduleToPrefix.get((Object)namespace));
    }

    public Optional<QNameModule> findNamespaceForPrefix(String prefix) {
        QNameModule normal = (QNameModule)this.moduleToPrefix.inverse().get((Object)prefix);
        return normal != null ? Optional.of(normal) : Optional.ofNullable((QNameModule)this.prefixToModule.get((Object)prefix));
    }
}

