/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.ir.IRStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangIRSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceTransformer;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.rfc7950.antlr.IRSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangModelDependencyInfo;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;

@Beta
public final class TextToIRTransformer
extends SchemaSourceTransformer<YangTextSchemaSource, YangIRSchemaSource> {
    private TextToIRTransformer(SchemaRepository provider, SchemaSourceRegistry consumer) {
        super(provider, YangTextSchemaSource.class, consumer, YangIRSchemaSource.class, input -> Futures.immediateFuture((Object)TextToIRTransformer.transformText(input)));
    }

    public static @NonNull TextToIRTransformer create(SchemaRepository provider, SchemaSourceRegistry consumer) {
        return new TextToIRTransformer(provider, consumer);
    }

    public static @NonNull YangIRSchemaSource transformText(YangTextSchemaSource text) throws YangSyntaxErrorException, IOException {
        IRStatement rootStatement = IRSupport.createStatement(YangStatementStreamSource.parseYangSource(text));
        String name = YangModelDependencyInfo.safeStringArgument(text.getIdentifier(), rootStatement, "name");
        String latestRevision = YangModelDependencyInfo.getLatestRevision(rootStatement, text.getIdentifier());
        SourceIdentifier sourceId = new SourceIdentifier(name, latestRevision);
        return new YangIRSchemaSource(sourceId, rootStatement, (String)text.getSymbolicName().orElse(null));
    }
}

