/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.if_feature;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.IfFeatureExpr;
import org.opendaylight.yangtools.yang.parser.antlr.IfFeatureExpressionLexer;
import org.opendaylight.yangtools.yang.parser.antlr.IfFeatureExpressionParser;
import org.opendaylight.yangtools.yang.parser.rfc7950.antlr.SourceExceptionParser;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@NonNullByDefault
final class IfFeaturePredicateParser {
    private final StmtContext<?, ?, ?> stmt;

    private IfFeaturePredicateParser(StmtContext<?, ?, ?> stmt) {
        this.stmt = Objects.requireNonNull(stmt);
    }

    static IfFeatureExpr parseIfFeatureExpression(StmtContext<?, ?, ?> stmt, String value) {
        IfFeatureExpressionLexer lexer = new IfFeatureExpressionLexer((CharStream)CharStreams.fromString((String)value));
        IfFeatureExpressionParser parser = new IfFeatureExpressionParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        IfFeatureExpressionParser.If_feature_exprContext ifFeatureExprContext = SourceExceptionParser.parse(lexer, parser, parser::if_feature_expr, stmt.sourceReference());
        return new IfFeaturePredicateParser(stmt).parseIfFeatureExpr(ifFeatureExprContext);
    }

    private IfFeatureExpr parseIfFeatureExpr(IfFeatureExpressionParser.If_feature_exprContext expr) {
        int count = this.verifyExprOrTermChildren(expr);
        ImmutableSet.Builder expressions = ImmutableSet.builderWithExpectedSize((int)(count / 4 + 1));
        for (int i = 0; i < count; i += 4) {
            expressions.add((Object)this.parseIfFeatureTerm(this.getChild(expr, i, IfFeatureExpressionParser.If_feature_termContext.class)));
        }
        return IfFeatureExpr.or((Set)expressions.build());
    }

    private IfFeatureExpr parseIfFeatureTerm(IfFeatureExpressionParser.If_feature_termContext term) {
        int count = this.verifyExprOrTermChildren(term);
        ImmutableSet.Builder expressions = ImmutableSet.builderWithExpectedSize((int)(count / 4 + 1));
        expressions.add((Object)this.parseIfFeatureFactor(this.getChild(term, 0, IfFeatureExpressionParser.If_feature_factorContext.class)));
        for (int i = 4; i < count; i += 4) {
            expressions.add((Object)this.parseIfFeatureTerm(this.getChild(term, i, IfFeatureExpressionParser.If_feature_termContext.class)));
        }
        return IfFeatureExpr.and((Set)expressions.build());
    }

    private IfFeatureExpr parseIfFeatureFactor(IfFeatureExpressionParser.If_feature_factorContext factor) {
        ParseTree first = factor.getChild(0);
        if (first instanceof IfFeatureExpressionParser.Identifier_ref_argContext) {
            IfFeatureExpressionParser.Identifier_ref_argContext refArg = (IfFeatureExpressionParser.Identifier_ref_argContext)first;
            return IfFeatureExpr.isPresent((QName)StmtContextUtils.parseNodeIdentifier(this.stmt, (String)refArg.getText()));
        }
        if (first instanceof TerminalNode) {
            TerminalNode terminal = (TerminalNode)first;
            return switch (terminal.getSymbol().getType()) {
                case 2 -> this.parseIfFeatureExpr((IfFeatureExpressionParser.If_feature_exprContext)factor.getChild(IfFeatureExpressionParser.If_feature_exprContext.class, 0));
                case 1 -> this.parseIfFeatureFactor(this.getChild(factor, 2, IfFeatureExpressionParser.If_feature_factorContext.class)).negate();
                default -> throw new SourceException(this.stmt, "Unexpected terminal %s in sub-expression at %s", new Object[]{terminal.getText(), factor.getSourceInterval()});
            };
        }
        throw new SourceException(this.stmt, "Unexpected error: sub-expression at %s has context %s. Please file a bug report with the corresponding model attached.", new Object[]{factor.getSourceInterval(), first});
    }

    private int verifyExprOrTermChildren(ParserRuleContext context) {
        int count = context.getChildCount();
        if (count % 4 != 1) {
            throw new SourceException(this.stmt, "Unexpected error: sub-expression at %s has %s children. Please file a bug report with the corresponding model attached.", new Object[]{context.getSourceInterval(), count});
        }
        return count;
    }

    private <T> T getChild(ParserRuleContext parent, int offset, Class<T> clazz) {
        ParseTree child = parent.getChild(offset);
        if (!clazz.isInstance(child)) {
            throw new SourceException(this.stmt, "Unexpected error: sub-expression at %s has child %s at offset %s when expecting %s. Please file a bug report with the corresponding model attached.", new Object[]{parent.getSourceInterval(), child, offset, clazz});
        }
        return clazz.cast(child);
    }
}

