/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import java.lang.runtime.SwitchBootstraps;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.MaxElementsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MaxElementsStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class MaxElementsStatementSupport
extends AbstractStatementSupport<String, MaxElementsStatement, MaxElementsEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).build();
    private static final String UNBOUNDED_STR = "unbounded";
    private static final Pattern POSITIVE_INTEGER_VALUE = Pattern.compile("[1-9][0-9]*");

    public MaxElementsStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.MAX_ELEMENTS, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public String internArgument(String rawArgument) {
        String string = rawArgument;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"1", "2", UNBOUNDED_STR}, (Object)string, n)) {
            case 0 -> "1";
            case 1 -> "2";
            case 2 -> UNBOUNDED_STR;
            default -> rawArgument;
        };
    }

    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        if (!UNBOUNDED_STR.equals(value) && !POSITIVE_INTEGER_VALUE.matcher(value).matches()) {
            throw new SourceException(ctx, "Invalid max-elements argument \"%s\"", new Object[]{value});
        }
        return value;
    }

    protected MaxElementsStatement createDeclared(BoundStmtCtx<String> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createMaxElements((String)ctx.getRawArgument(), (String)((String)ctx.getArgument()), substatements);
    }

    protected MaxElementsStatement attachDeclarationReference(MaxElementsStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateMaxElements((MaxElementsStatement)stmt, (DeclarationReference)reference);
    }

    protected MaxElementsEffectiveStatement createEffective(EffectiveStmtCtx.Current<String, MaxElementsStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createMaxElements((MaxElementsStatement)((MaxElementsStatement)stmt.declared()), substatements);
    }
}

