/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.Submodule;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractEffectiveModule;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;

final class ModuleEffectiveStatementImpl
extends AbstractEffectiveModule<ModuleStatement, ModuleEffectiveStatement>
implements Module,
ModuleEffectiveStatement {
    private final ImmutableMap<UnresolvedQName.Unqualified, SubmoduleEffectiveStatement> nameToSubmodule;
    private final ImmutableMap<QName, ExtensionEffectiveStatement> qnameToExtension;
    private final ImmutableMap<QName, FeatureEffectiveStatement> qnameToFeature;
    private final ImmutableMap<QName, IdentityEffectiveStatement> qnameToIdentity;
    private final ImmutableMap<String, ModuleEffectiveStatement> prefixToModule;
    private final ImmutableMap<QNameModule, String> namespaceToPrefix;
    private final @NonNull QNameModule qnameModule;
    private final ImmutableList<Submodule> submodules;

    ModuleEffectiveStatementImpl(EffectiveStmtCtx.Current<UnresolvedQName.Unqualified, ModuleStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, Collection<? extends Submodule> submodules, QNameModule qnameModule) {
        super(stmt, substatements, ModuleEffectiveStatementImpl.findPrefix(stmt, substatements, "module", stmt.getRawArgument()));
        this.qnameModule = Objects.requireNonNull(qnameModule);
        this.submodules = ImmutableList.copyOf(submodules);
        String localPrefix = (String)this.prefix().argument();
        ImmutableMap.Builder prefixToModuleBuilder = ImmutableMap.builder();
        prefixToModuleBuilder.put((Object)localPrefix, (Object)this);
        this.appendPrefixes(stmt, (ImmutableMap.Builder<String, ModuleEffectiveStatement>)prefixToModuleBuilder);
        this.prefixToModule = prefixToModuleBuilder.build();
        LinkedHashMap<QNameModule, String> tmp = LinkedHashMap.newLinkedHashMap(this.prefixToModule.size() + 1);
        tmp.put(qnameModule, localPrefix);
        for (Map.Entry e : this.prefixToModule.entrySet()) {
            tmp.putIfAbsent(((ModuleEffectiveStatement)e.getValue()).localQNameModule(), (String)e.getKey());
        }
        this.namespaceToPrefix = ImmutableMap.copyOf(tmp);
        Map includedSubmodules = stmt.localNamespacePortion(ParserNamespaces.INCLUDED_SUBMODULE_NAME_TO_MODULECTX);
        this.nameToSubmodule = includedSubmodules == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)Maps.transformValues((Map)includedSubmodules, submodule -> (SubmoduleEffectiveStatement)submodule.buildEffective()));
        this.qnameToExtension = (ImmutableMap)substatements.stream().filter(ExtensionEffectiveStatement.class::isInstance).map(ExtensionEffectiveStatement.class::cast).collect(ImmutableMap.toImmutableMap(ModelStatement::argument, Function.identity()));
        this.qnameToFeature = (ImmutableMap)substatements.stream().filter(FeatureEffectiveStatement.class::isInstance).map(FeatureEffectiveStatement.class::cast).collect(ImmutableMap.toImmutableMap(ModelStatement::argument, Function.identity()));
        this.qnameToIdentity = (ImmutableMap)substatements.stream().filter(IdentityEffectiveStatement.class::isInstance).map(IdentityEffectiveStatement.class::cast).collect(ImmutableMap.toImmutableMap(ModelStatement::argument, Function.identity()));
    }

    public ModuleEffectiveStatement.ConformanceType conformance() {
        return ModuleEffectiveStatement.ConformanceType.IMPLEMENT;
    }

    public QNameModule localQNameModule() {
        return this.qnameModule;
    }

    public QNameModule getQNameModule() {
        return this.qnameModule;
    }

    public Collection<? extends @NonNull Submodule> getSubmodules() {
        return this.submodules;
    }

    public ModuleEffectiveStatement asEffectiveStatement() {
        return this;
    }

    public Collection<ExtensionEffectiveStatement> extensions() {
        return this.qnameToExtension.values();
    }

    public Optional<ExtensionEffectiveStatement> findExtension(QName qname) {
        return ModuleEffectiveStatementImpl.findValue(this.qnameToExtension, (Object)qname);
    }

    public Collection<FeatureEffectiveStatement> features() {
        return this.qnameToFeature.values();
    }

    public Optional<FeatureEffectiveStatement> findFeature(QName qname) {
        return ModuleEffectiveStatementImpl.findValue(this.qnameToFeature, (Object)qname);
    }

    public Collection<IdentityEffectiveStatement> identities() {
        return this.qnameToIdentity.values();
    }

    public Optional<IdentityEffectiveStatement> findIdentity(QName qname) {
        return ModuleEffectiveStatementImpl.findValue(this.qnameToIdentity, (Object)qname);
    }

    public Collection<Map.Entry<String, ModuleEffectiveStatement>> reachableModules() {
        return this.prefixToModule.entrySet();
    }

    public Optional<ModuleEffectiveStatement> findReachableModule(String prefix) {
        return ModuleEffectiveStatementImpl.findValue(this.prefixToModule, (Object)prefix);
    }

    public Optional<String> findNamespacePrefix(QNameModule namespace) {
        return ModuleEffectiveStatementImpl.findValue(this.namespaceToPrefix, (Object)namespace);
    }

    public Collection<Map.Entry<QNameModule, String>> namespacePrefixes() {
        return this.namespaceToPrefix.entrySet();
    }

    public Collection<SubmoduleEffectiveStatement> submodules() {
        return this.nameToSubmodule.values();
    }

    public Optional<SubmoduleEffectiveStatement> findSubmodule(UnresolvedQName.Unqualified submoduleName) {
        return ModuleEffectiveStatementImpl.findValue(this.nameToSubmodule, (Object)submoduleName);
    }
}

