/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BitEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.ri.type.BitsTypeBuilder;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BitsSpecificationImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EffectiveTypeUtil;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.RefBitsSpecification;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class BitsSpecificationSupport
extends AbstractTypeSupport<TypeStatement.BitsSpecification> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMultiple((StatementDefinition)YangStmtMapping.BIT).build();

    BitsSpecificationSupport(YangParserConfiguration config) {
        super(config, SUBSTATEMENT_VALIDATOR);
    }

    protected TypeStatement.BitsSpecification createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        if (substatements.isEmpty()) {
            throw BitsSpecificationSupport.noBits(ctx);
        }
        return new BitsSpecificationImpl(ctx.getRawArgument(), (QName)ctx.getArgument(), substatements);
    }

    protected TypeStatement.BitsSpecification attachDeclarationReference(TypeStatement.BitsSpecification stmt, DeclarationReference reference) {
        return new RefBitsSpecification(stmt, reference);
    }

    protected EffectiveStatement<QName, TypeStatement.BitsSpecification> createEffective(EffectiveStmtCtx.Current<QName, TypeStatement.BitsSpecification> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        if (substatements.isEmpty()) {
            throw BitsSpecificationSupport.noBits(stmt);
        }
        BitsTypeBuilder builder = BaseTypes.bitsTypeBuilder((QName)stmt.argumentAsTypeQName());
        Uint32 highestPosition = null;
        for (EffectiveStatement subStmt : substatements) {
            Uint32 effectivePos;
            if (!(subStmt instanceof BitEffectiveStatement)) continue;
            BitEffectiveStatement bitSubStmt = (BitEffectiveStatement)subStmt;
            Optional declaredPosition = bitSubStmt.findDeclaredPosition();
            if (declaredPosition.isEmpty()) {
                if (highestPosition != null) {
                    SourceException.throwIf((boolean)Uint32.MAX_VALUE.equals(highestPosition), stmt, (String)"Bit %s must have a position statement", (Object[])new Object[]{bitSubStmt});
                    effectivePos = Uint32.fromIntBits((int)(highestPosition.intValue() + 1));
                } else {
                    effectivePos = Uint32.ZERO;
                }
            } else {
                effectivePos = (Uint32)declaredPosition.orElseThrow();
            }
            BitsTypeDefinition.Bit bit = EffectiveTypeUtil.buildBit(bitSubStmt, effectivePos);
            if (highestPosition == null || highestPosition.compareTo(bit.getPosition()) < 0) {
                highestPosition = bit.getPosition();
            }
            builder.addBit(bit);
        }
        return new TypeEffectiveStatementImpl((TypeStatement.BitsSpecification)stmt.declared(), (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static SourceException noBits(CommonStmtCtx stmt) {
        return new SourceException("At least one bit statement has to be present", stmt);
    }
}

